\name{icc_pmf_criteria}
\alias{icc_pmf_criteria}
\title{
ICC Diagnostic Criteria for Primary Myelofibrosis (PMF)
}
\description{
Evaluates the International Consensus Classification (ICC) diagnostic criteria for Primary Myelofibrosis (PMF). Diagnosis requires meeting all 3 Major criteria and at least 1 Minor criterion. This applies to both Prefibrotic/Early PMF and Overt PMF (though specific histologic features differ between the two, the checklist structure is shared).
}
\usage{
icc_pmf_criteria(histology_consistent, exclusion_of_other_neoplasms,
                 clonal_marker_present, anemia, leukocytosis, splenomegaly,
                 ldh_elevated, leukoerythroblastosis)
}
\arguments{
  \item{histology_consistent}{
Numeric (0 or 1). Major Criterion: Megakaryocytic proliferation with atypia and either reticulin/collagen fibrosis (grades 2-3 for Overt) or granulocytic proliferation with decreased erythropoiesis (for Prefibrotic). (1 = Yes).
}
  \item{exclusion_of_other_neoplasms}{
Numeric (0 or 1). Major Criterion: Not meeting WHO/ICC criteria for CML, PV, ET, MDS, or other myeloid neoplasm. (1 = Yes).
}
  \item{clonal_marker_present}{
Numeric (0 or 1). Major Criterion: Presence of JAK2, CALR, or MPL mutation; OR presence of another clonal marker (e.g., ASXL1, EZH2, TET2, IDH1/IDH2, SRSF2, SF3B1); OR absence of reactive reticulin fibrosis. (1 = Yes).
}
  \item{anemia}{
Numeric (0 or 1). Minor Criterion: Anemia not attributed to a comorbid condition. (1 = Yes).
}
  \item{leukocytosis}{
Numeric (0 or 1). Minor Criterion: Leukocytosis (WBC >= 11 x 10^9/L). (1 = Yes).
}
  \item{splenomegaly}{
Numeric (0 or 1). Minor Criterion: Palpable splenomegaly. (1 = Yes).
}
  \item{ldh_elevated}{
Numeric (0 or 1). Minor Criterion: LDH level above the upper limit of normal. (1 = Yes).
}
  \item{leukoerythroblastosis}{
Numeric (0 or 1). Minor Criterion: Leukoerythroblastosis. (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Primary Myelofibrosis (PMF)" or "Criteria Not Met".}
\item{Major_Criteria_Met}{Count of major criteria satisfied (Max 3).}
\item{Minor_Criteria_Met}{Count of minor criteria satisfied.}
}
\references{
Arber DA, Orazi A, Hasserjian RP, et al. International Consensus Classification of Myeloid Neoplasms and Acute Leukemias: integrating morphologic, clinical, and genomic data. Blood. 2022;140(11):1200-1228. doi:10.1182/blood.2022015850
}
\examples{

# Example 1: Diagnosis Met
# Histology (1), No CML/PV (1), JAK2+ (1), Anemia (1)
icc_pmf_criteria(1, 1, 1, 1, 0, 0, 0, 0)

# Example 2: Diagnosis Not Met
# Histology (1), No CML/PV (1), No Clonal Marker (0), No Minor Signs
icc_pmf_criteria(1, 1, 0, 0, 0, 0, 0, 0)
}
