\name{hunt_hess_classification}
\alias{hunt_hess_classification}
\title{
Hunt and Hess Classification for Subarachnoid Hemorrhage
}
\description{
Retrieves the Hunt and Hess Grade for patients with subarachnoid hemorrhage (SAH). This classification system correlates the severity of clinical presentation with surgical risk and mortality.
}
\usage{
hunt_hess_classification(clinical_findings)
}
\arguments{
  \item{clinical_findings}{
Numeric (1-5). Select the grade corresponding to the patient's clinical status:
1: Asymptomatic, mild headache, or slight nuchal rigidity.
2: Moderate/severe headache, nuchal rigidity, no deficit (except CN palsy).
3: Drowsy, confused, or mild focal deficit.
4: Stupor, moderate-severe hemiparesis, early decerebrate rigidity.
5: Deep coma, decerebrate rigidity, moribund.
}
}
\value{
A list containing:
\item{Hunt_Hess_Grade}{The input grade.}
\item{Description}{The clinical description associated with the grade.}
\item{Mortality_Rate}{Estimated mortality percentage associated with the grade.}
}
\references{
Hunt WE, Hess RM. Surgical risk as related to time of intervention in the repair of intracranial aneurysms. J Neurosurg. 1968;28(1):14-20. doi:10.3171/jns.1968.28.1.0014
}
\examples{

# Example 1: Grade 2
# Severe headache and stiff neck
hunt_hess_classification(2)

# Example 2: Grade 5
# Comatose patient
hunt_hess_classification(5)
}
