\name{epds_score}
\alias{epds_score}
\title{
Edinburgh Postnatal Depression Scale (EPDS)
}
\description{
Calculates the EPDS score, a 10-item screening tool used to identify women who may have postpartum depression. Each item is scored 0, 1, 2, or 3 based on the intensity of symptoms over the past 7 days. Item 10 specifically screens for suicidal ideation.
}
\usage{
epds_score(q1_laugh, q2_enjoy, q3_blame, q4_anxious, q5_scared, q6_coping,
           q7_sleep, q8_sad, q9_crying, q10_self_harm)
}
\arguments{
  \item{q1_laugh}{
Numeric (0-3). "I have been able to laugh and see the funny side of things." (0=As much as always, 3=Not at all).
}
  \item{q2_enjoy}{
Numeric (0-3). "I have looked forward with enjoyment to things." (0=As much as ever, 3=Hardly at all).
}
  \item{q3_blame}{
Numeric (0-3). "I have blamed myself unnecessarily when things went wrong." (0=Never, 3=Yes, most of the time).
}
  \item{q4_anxious}{
Numeric (0-3). "I have been anxious or worried for no good reason." (0=No, not at all, 3=Yes, very often).
}
  \item{q5_scared}{
Numeric (0-3). "I have felt scared or panicky for no very good reason." (0=No, not at all, 3=Yes, quite a lot).
}
  \item{q6_coping}{
Numeric (0-3). "Things have been getting on top of me." (0=No, I have been coping as well as ever, 3=Yes, most of the time I haven't been able to cope).
}
  \item{q7_sleep}{
Numeric (0-3). "I have been so unhappy that I have had difficulty sleeping." (0=No, not at all, 3=Yes, most of the time).
}
  \item{q8_sad}{
Numeric (0-3). "I have felt sad or miserable." (0=No, not at all, 3=Yes, most of the time).
}
  \item{q9_crying}{
Numeric (0-3). "I have been so unhappy that I have been crying." (0=No, never, 3=Yes, most of the time).
}
  \item{q10_self_harm}{
Numeric (0-3). "The thought of harming myself has occurred to me." (0=Never, 1=Hardly ever, 2=Sometimes, 3=Yes, quite often). **Note:** Any score > 0 on this item suggests immediate risk.
}
}
\value{
A list containing:
\item{EPDS_Total_Score}{The sum of the 10 items (Range 0-30).}
\item{Interpretation}{Risk category (Not likely, Possible, Probable).}
\item{Suicide_Risk_Flag}{Boolean indicating if Q10 was positive.}
\item{Action_Plan}{Suggested clinical next steps.}
}
\references{
Cox JL, Holden JM, Sagovsky R. Detection of postnatal depression. Development of the 10-item Edinburgh Postnatal Depression Scale. Br J Psychiatry. 1987;150:782-786. doi:10.1192/bjp.150.6.782
}
\examples{

# Example 1: High Risk (Probable Depression + Self Harm)
# High scores on sadness, coping, and self-harm
epds_score(1, 2, 2, 2, 2, 3, 2, 3, 2, 1)

# Example 2: Low Risk
# Mostly 0s and 1s
epds_score(0, 0, 1, 0, 1, 0, 0, 1, 0, 0)
}
