\name{cpis_vap_score}
\alias{cpis_vap_score}
\title{
Clinical Pulmonary Infection Score (CPIS) for VAP
}
\description{
Calculates the Clinical Pulmonary Infection Score (CPIS) to assist in the diagnosis of Ventilator-Associated Pneumonia (VAP). The score evaluates six clinical, physiological, radiographic, and microbiological variables. A score greater than 6 typically correlates with the presence of VAP (sensitivity 77\%, specificity 42\%).
}
\usage{
cpis_vap_score(temp_c, wbc_count, band_forms_present, tracheal_secretions,
               pao2_fio2_ratio, ards_present, chest_xray, culture_results = 0)
}
\arguments{
  \item{temp_c}{
Numeric. Body temperature in degrees Celsius.
36.5 - 38.4: 0 pts.
38.5 - 38.9: 1 pt.
< 36.5 or >= 39.0: 2 pts.
}
  \item{wbc_count}{
Numeric. White Blood Cell count (cells/mm3 or uL).
4,000 - 11,000: 0 pts.
< 4,000 or > 11,000: 1 pt (unless bands present).
}
  \item{band_forms_present}{
Numeric (0 or 1). Presence of >= 500 band forms. (1 = Yes).
If WBC is abnormal AND bands are present, score is 2 pts.
}
  \item{tracheal_secretions}{
Numeric (0, 1, or 2).
0: Rare / Absence of tracheal secretions.
1: Abundant tracheal secretions.
2: Abundant + Purulent tracheal secretions.
}
  \item{pao2_fio2_ratio}{
Numeric. PaO2/FiO2 ratio (mmHg).
> 240: 0 pts.
<= 240: 2 pts (Only if ARDS is NOT present).
}
  \item{ards_present}{
Numeric (0 or 1). Presence of ARDS (Acute Respiratory Distress Syndrome). (1 = Yes).
If ARDS is present, the oxygenation score is 0 regardless of the P/F ratio.
}
  \item{chest_xray}{
Numeric (0, 1, or 2). Chest radiograph findings.
0: No infiltrate.
1: Diffuse or patchy infiltrate.
2: Localized infiltrate.
}
  \item{culture_results}{
Numeric (0, 1, or 2). Culture of tracheal aspirate. Defaults to 0 if not yet available.
0: Negative or rare growth.
1: Pathogenic bacteria cultured (moderate/heavy).
2: Pathogenic bacteria cultured (moderate/heavy) + Same bacteria on Gram stain.
}
}
\value{
A list containing:
\item{CPIS_Score}{The calculated total score (Range 0-12).}
\item{Interpretation}{Clinical suggestion ("Suggestive of VAP" if Score > 6).}
}
\references{
Pugin J, Auckenthaler R, Mili N, et al. Diagnosis of ventilator-associated pneumonia by bacteriologic analysis of bronchoscopic and nonbronchoscopic "blind" bronchoalveolar lavage fluid. Am Rev Respir Dis. 1991;143(5 Pt 1):1121-1129. doi:10.1164/ajrccm/143.5_Pt_1.1121
}
\examples{

# Example 1: Suggestive of VAP
# Temp 39.0 (+2), WBC 15k with Bands (+2), Purulent Secretions (+2),
# PF 200 No ARDS (+2), Localized CXR (+2), Culture Pending (0)
# Score = 10
cpis_vap_score(39.0, 15000, 1, 2, 200, 0, 2, 0)

# Example 2: Low Likelihood
# Temp 37.0 (0), WBC 8000 (0), Rare secretions (0), PF 300 (0), Diffuse CXR (1)
# Score = 1
cpis_vap_score(37.0, 8000, 0, 0, 300, 0, 1, 0)
}
