\name{clinical_dementia_rating}
\alias{clinical_dementia_rating}
\title{
Clinical Dementia Rating (CDR) Scale
}
\description{
Calculates the Global CDR Score and the CDR Sum of Boxes (CDR-SB). The CDR is a global rating scale for staging dementia severity based on six domains of cognitive and functional performance: Memory, Orientation, Judgment & Problem Solving, Community Affairs, Home & Hobbies, and Personal Care.
}
\usage{
clinical_dementia_rating(memory, orientation, judgment, community,
                         home_hobbies, personal_care)
}
\arguments{
  \item{memory}{
Numeric (0, 0.5, 1, 2, 3). Assessment of memory impairment. This is the primary category that drives the algorithm.
}
  \item{orientation}{
Numeric (0, 0.5, 1, 2, 3). Assessment of orientation to time, place, and person.
}
  \item{judgment}{
Numeric (0, 0.5, 1, 2, 3). Assessment of judgment and problem-solving abilities.
}
  \item{community}{
Numeric (0, 0.5, 1, 2, 3). Assessment of involvement in community affairs.
}
  \item{home_hobbies}{
Numeric (0, 0.5, 1, 2, 3). Assessment of ability to perform home chores and hobbies.
}
  \item{personal_care}{
Numeric (0, 0.5, 1, 2, 3). Assessment of personal care status.
}
}
\details{
\strong{Scoring Values:}
0 = None
0.5 = Questionable/Very Mild
1 = Mild
2 = Moderate
3 = Severe

The Global CDR is calculated using the standard Washington University algorithm, where Memory (M) determines the baseline, and the configuration of secondary scores determines if the global score shifts up or down. The CDR-SB is the simple sum of all 6 scores.
}
\value{
A list containing:
\item{Global_CDR_Score}{The staging score (0, 0.5, 1, 2, or 3).}
\item{CDR_Sum_of_Boxes}{The sum of all domain scores (Range 0-18). Useful for tracking detailed progression.}
\item{Stage}{Text description of the dementia severity.}
}
\references{
Morris JC. The Clinical Dementia Rating (CDR): current version and scoring rules. Neurology. 1993;43(11):2412-2414. doi:10.1212/wnl.43.11.2412-a
}
\examples{

# Example 1: Mild Dementia
# Memory 1, others mostly 1
clinical_dementia_rating(1, 1, 1, 0.5, 1, 0.5)

# Example 2: Questionable Dementia (CDR 0.5)
# Memory 0.5, others 0.5
clinical_dementia_rating(0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

# Example 3: Normal
# All 0
clinical_dementia_rating(0, 0, 0, 0, 0, 0)
}
