% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilityCalc.R
\name{stabilityCalc}
\alias{stabilityCalc}
\title{Calculate stability from deviation}
\usage{
stabilityCalc(rasterForCalculation)
}
\arguments{
\item{rasterForCalculation}{A `SpatRaster` object that contains data from which stability is to be
calculated.}
}
\value{
A raster
}
\description{
A function to calculate stability based on the results of `deviationThroughTime`.
}
\details{
This formula takes the inverse of the raster and rescales it from 0 to 1.This function is
necessary in cases where there is no deviation in some cells. If time slices are very close
together, it's possible that some cells may have values equal to zero, at which point if you
simply divide 1 by the raster and rescale the result, you can end up with a raster full of zeroes.
}
\examples{

precipDeviation <- terra::rast(system.file("extdata/precipDeviation.asc",
                                           package = "climateStability"))
precipStability <- stabilityCalc(precipDeviation)

}
\references{
Owens, H.L., Guralnick, R., 2019. climateStability: An R package to estimate
climate stability from time-slice climatologies. Biodiversity Informatics
14, 8–13. https://doi.org/10.17161/bi.v14i0.9786
}
\keyword{manip}
