% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latitudinalMean.R
\name{latitudinalMean}
\alias{latitudinalMean}
\title{latitudinalMean}
\usage{
latitudinalMean(rasterForCalculation)
}
\arguments{
\item{rasterForCalculation}{A raster that contains data for plotting according to latitudinal value}
}
\value{
A vector of raster values for each absolute value of latitude.
}
\description{
A function to calculate mean values of a raster at every line of latitude, at the resolution of a given raster layer. Put another way, for each row in the raster, it calculates a mean.
}
\examples{

precipDeviation <- terra::rast(system.file("extdata/precipDeviation.asc",
                                            package = "climateStability"))
precipStability <- 1/precipDeviation
latMean <- latitudinalMean(rasterForCalculation = precipStability)
plot(latMean, main = "Precipitation Stability by Latitude",
ylab = "Relative Stability", type = "l")

}
\references{
Owens, H.L., Guralnick, R., 2019. climateStability: An R package to estimate
climate stability from time-slice climatologies. Biodiversity Informatics
14, 8–13. https://doi.org/10.17161/bi.v14i0.9786
}
\seealso{
\code{\link{absLatitudinalMean}} to calculate mean value for each absolute value of latitude.
}
\keyword{manip}
