% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliff.R
\name{run}
\alias{run}
\title{Run a command line program and wait until it terminates.}
\usage{
run(
  command,
  ...,
  input = NULL,
  error_on_status = TRUE,
  wd = NULL,
  timeout = Inf,
  env = NULL
)
}
\arguments{
\item{command}{the command to run}

\item{...}{the arguments pass to the program, supports the
\href{https://rlang.r-lib.org/reference/nse-force.html}{big bang} operator \verb{!!!}}

\item{input}{text pass to stdin}

\item{error_on_status}{raise an error if return code is not 0.}

\item{wd}{working directory}

\item{timeout}{throw an error after this amount of time in second}

\item{env}{additional environment variables}
}
\value{
The stdout of the program in a scalar character.
It may contain a trailing newline. Use \code{trimws()} to
ensure the trailing newline is trimmed.
}
\description{
Run a command line program and wait until it terminates.
}
\examples{
\dontrun{
git <- function(...) cliff::run("git", ...)
git("log", git("rev-parse", "--abbrev-ref", "HEAD"), "-n1")
}

}
