% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{station_jp}
\alias{station_jp}
\title{Climate stations in Japan}
\format{
A data frame with 3444 rows and 4 variable:
\describe{
\item{region       }{Rejon. Escaped by stringi::stri_escape_unicode().}
\item{pref         }{Prefecture. Escaped by stringi::stri_escape_unicode()}
\item{no           }{Station no.}
\item{station      }{Station name. To avoid duplication, including country name after station name. Can split by "_". Escaped by stringi::stri_escape_unicode().}
\item{altitude     }{Altitude. (m)}
\item{latitude     }{Latitude. (degree)}
\item{longitude    }{Longitude. (degree)}
\item{NS           }{North or South.}
\item{WE           }{West or East.}
\item{yomi         }{Pronunciation in Japanese. Escaped by stringi::stri_escape_unicode()}
\item{city         }{City name. Escaped by stringi::stri_escape_unicode().}
}
}
\usage{
station_jp
}
\description{
Climate stations in Japan
}
\examples{
library(magrittr)
library(stringi)
library(dplyr)
data(station_jp)
station_jp \%>\%
  dplyr::mutate_all(stringi::stri_unescape_unicode)
}
\keyword{datasets}
