% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clarabel.R
\name{solver_update}
\alias{solver_update}
\title{Update problem data on a persistent Clarabel solver}
\usage{
solver_update(solver, P = NULL, q = NULL, A = NULL, b = NULL)
}
\arguments{
\item{solver}{a \code{ClarabelSolver} object created by
\code{\link[=clarabel_solver]{clarabel_solver()}}}

\item{P}{new upper-triangular P matrix (same sparsity), or \code{NULL}
to leave unchanged}

\item{q}{new linear objective vector, or \code{NULL} to leave unchanged}

\item{A}{new constraint matrix (same sparsity), or \code{NULL} to leave
unchanged}

\item{b}{new constraint RHS vector, or \code{NULL} to leave unchanged}
}
\value{
invisible \code{NULL}
}
\description{
Update one or more of P (objective), q (linear objective), A
(constraints), b (constraint RHS) on an existing solver. The
sparsity pattern of P and A must remain the same as the original
problem; only the nonzero values can change.
}
\examples{
\dontrun{
solver_update(s, q = c(-4, -1))   # update linear objective only
solver_update(s, b = c(2, 2))     # update constraint RHS only
sol2 <- solver_solve(s)           # re-solve with updated data
}
}
\seealso{
\code{\link[=clarabel_solver]{clarabel_solver()}}, \code{\link[=solver_solve]{solver_solve()}}
}
