% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clarabel.R
\name{clarabel_solver}
\alias{clarabel_solver}
\title{Create a persistent Clarabel solver object}
\usage{
clarabel_solver(
  A,
  b,
  q,
  P = NULL,
  cones,
  control = list(),
  strict_cone_order = TRUE
)
}
\arguments{
\item{A}{a matrix of constraint coefficients.}

\item{b}{a numeric vector giving the primal constraints}

\item{q}{a numeric vector giving the primal objective}

\item{P}{a symmetric positive semidefinite matrix, default
\code{NULL}}

\item{cones}{a named list giving the cone sizes, see \dQuote{Cone
Parameters} below for specification}

\item{control}{a list giving specific control parameters to use in
place of default values, with an empty list indicating the
default control parameters. Specified parameters should be
correctly named and typed to avoid Rust system panics as no
sanitization is done for efficiency reasons}

\item{strict_cone_order}{a logical flag, default \code{TRUE} for forcing
order of cones described below. If \code{FALSE} cones can be specified
in any order and even repeated and directly passed to the solver
without type and length checks}
}
\value{
a \code{ClarabelSolver} environment object with methods
\code{solve()}, \code{update_data(Px, Ax, q, b)}, and
\code{is_update_allowed()}
}
\description{
Creates a persistent solver that can be reused across multiple
solves with updated problem data (warm starts). This avoids the
overhead of reallocating the solver's internal data structures when
only the problem data changes but the sparsity pattern stays the
same.
}
\details{
For data updates to work, the solver settings must have
\code{presolve_enable = FALSE}, \code{chordal_decomposition_enable = FALSE},
and \code{input_sparse_dropzeros = FALSE}. Use
\code{\link[=solver_is_update_allowed]{solver_is_update_allowed()}} to check after construction.
}
\examples{
\dontrun{
P <- Matrix::sparseMatrix(i = 1:2, j = 1:2, x = c(2, 1), dims = c(2, 2))
A <- matrix(c(1, 0, 0, 1), nrow = 2)
b <- c(1, 1)
q <- c(-2, -3)
cones <- list(l = 2L)
ctrl <- clarabel_control(presolve_enable = FALSE, verbose = FALSE)
s <- clarabel_solver(A, b, q, P, cones, control = ctrl)
sol1 <- solver_solve(s)
solver_update(s, q = c(-4, -1))
sol2 <- solver_solve(s)
}
}
\seealso{
\code{\link[=solver_solve]{solver_solve()}}, \code{\link[=solver_update]{solver_update()}},
\code{\link[=solver_is_update_allowed]{solver_is_update_allowed()}}, \code{\link[=clarabel]{clarabel()}}
}
