% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clarabel.R
\name{clarabel_control}
\alias{clarabel_control}
\title{Control parameters with default values and types in parenthesis}
\usage{
clarabel_control(
  max_iter = 200L,
  time_limit = Inf,
  verbose = TRUE,
  max_step_fraction = 0.99,
  tol_gap_abs = 1e-08,
  tol_gap_rel = 1e-08,
  tol_feas = 1e-08,
  tol_infeas_abs = 1e-08,
  tol_infeas_rel = 1e-08,
  tol_ktratio = 1e-06,
  reduced_tol_gap_abs = 5e-05,
  reduced_tol_gap_rel = 5e-05,
  reduced_tol_feas = 1e-04,
  reduced_tol_infeas_abs = 5e-05,
  reduced_tol_infeas_rel = 5e-05,
  reduced_tol_ktratio = 1e-04,
  equilibrate_enable = TRUE,
  equilibrate_max_iter = 10L,
  equilibrate_min_scaling = 1e-04,
  equilibrate_max_scaling = 10000,
  linesearch_backtrack_step = 0.8,
  min_switch_step_length = 0.1,
  min_terminate_step_length = 1e-04,
  max_threads = 0L,
  direct_kkt_solver = TRUE,
  direct_solve_method = c("qdldl", "mkl", "cholmod"),
  static_regularization_enable = TRUE,
  static_regularization_constant = 1e-08,
  static_regularization_proportional = .Machine$double.eps * .Machine$double.eps,
  dynamic_regularization_enable = TRUE,
  dynamic_regularization_eps = 1e-13,
  dynamic_regularization_delta = 2e-07,
  iterative_refinement_enable = TRUE,
  iterative_refinement_reltol = 1e-13,
  iterative_refinement_abstol = 1e-12,
  iterative_refinement_max_iter = 10L,
  iterative_refinement_stop_ratio = 5,
  presolve_enable = TRUE,
  input_sparse_dropzeros = FALSE,
  chordal_decomposition_enable = FALSE,
  chordal_decomposition_merge_method = c("none", "parent_child", "clique_graph"),
  chordal_decomposition_compact = FALSE,
  chordal_decomposition_complete_dual = FALSE
)
}
\arguments{
\item{max_iter}{maximum number of iterations (\code{200L})}

\item{time_limit}{maximum run time (seconds) (\code{Inf})}

\item{verbose}{verbose printing (\code{TRUE})}

\item{max_step_fraction}{maximum interior point step length (\code{0.99})}

\item{tol_gap_abs}{absolute duality gap tolerance (\code{1e-8})}

\item{tol_gap_rel}{relative duality gap tolerance (\code{1e-8})}

\item{tol_feas}{feasibility check tolerance (primal and dual) (\code{1e-8})}

\item{tol_infeas_abs}{absolute infeasibility tolerance (primal and dual) (\code{1e-8})}

\item{tol_infeas_rel}{relative infeasibility tolerance (primal and dual) (\code{1e-8})}

\item{tol_ktratio}{KT tolerance (\code{1e-7})}

\item{reduced_tol_gap_abs}{reduced absolute duality gap tolerance (\code{5e-5})}

\item{reduced_tol_gap_rel}{reduced relative duality gap tolerance (\code{5e-5})}

\item{reduced_tol_feas}{reduced feasibility check tolerance (primal and dual) (\code{1e-4})}

\item{reduced_tol_infeas_abs}{reduced absolute infeasibility tolerance (primal and dual) (\code{5e-5})}

\item{reduced_tol_infeas_rel}{reduced relative infeasibility tolerance (primal and dual) (\code{5e-5})}

\item{reduced_tol_ktratio}{reduced KT tolerance (\code{1e-4})}

\item{equilibrate_enable}{enable data equilibration pre-scaling (\code{TRUE})}

\item{equilibrate_max_iter}{maximum equilibration scaling iterations (\code{10L})}

\item{equilibrate_min_scaling}{minimum equilibration scaling allowed (\code{1e-4})}

\item{equilibrate_max_scaling}{maximum equilibration scaling allowed (\code{1e+4})}

\item{linesearch_backtrack_step}{linesearch backtracking (\code{0.8})}

\item{min_switch_step_length}{minimum step size allowed for asymmetric cones with PrimalDual scaling (\code{1e-1})}

\item{min_terminate_step_length}{minimum step size allowed for symmetric cones && asymmetric cones with Dual scaling (\code{1e-4})}

\item{max_threads}{maximum solver threads for multithreaded KKT solvers, 0 lets the solver choose for itself (\code{0L})}

\item{direct_kkt_solver}{use a direct linear solver method (required true) (\code{TRUE})}

\item{direct_solve_method}{direct linear solver (\code{"qdldl"}, \code{"mkl"} or \code{"cholmod"}) (\code{"qdldl"})}

\item{static_regularization_enable}{enable KKT static regularization (\code{TRUE})}

\item{static_regularization_constant}{KKT static regularization parameter (\code{1e-8})}

\item{static_regularization_proportional}{additional regularization parameter w.r.t. the maximum abs diagonal term (\code{.Machine.double_eps^2})}

\item{dynamic_regularization_enable}{enable KKT dynamic regularization (\code{TRUE})}

\item{dynamic_regularization_eps}{KKT dynamic regularization threshold (\code{1e-13})}

\item{dynamic_regularization_delta}{KKT dynamic regularization shift (\code{2e-7})}

\item{iterative_refinement_enable}{KKT solve with iterative refinement (\code{TRUE})}

\item{iterative_refinement_reltol}{iterative refinement relative tolerance (\code{1e-12})}

\item{iterative_refinement_abstol}{iterative refinement absolute tolerance (\code{1e-12})}

\item{iterative_refinement_max_iter}{iterative refinement maximum iterations (\code{10L})}

\item{iterative_refinement_stop_ratio}{iterative refinement stalling tolerance (\code{5.0})}

\item{presolve_enable}{whether to enable presolvle (\code{TRUE})}

\item{input_sparse_dropzeros}{explicitly drop structural zeros from sparse data inputs (\code{FALSE}); see details}

\item{chordal_decomposition_enable}{whether to enable chordal decomposition for SDPs (\code{FALSE})}

\item{chordal_decomposition_merge_method}{chordal decomposition merge method, one of \code{'none'}, \code{'parent_child'} or \code{'clique_graph'}, for SDPs (\code{'none'})}

\item{chordal_decomposition_compact}{a boolean flag for SDPs indicating whether to assemble decomposed system in \emph{compact} form for SDPs (\code{FALSE})}

\item{chordal_decomposition_complete_dual}{a boolean flag indicating complete PSD dual variables after decomposition for SDPs}
}
\value{
a list containing the control parameters.
}
\description{
Control parameters with default values and types in parenthesis
}
\details{
Setting \code{input_sparse_dropzeros} to \code{TRUE} will disable parametric updating functionality. See documentation of 'dropzeros' in Rust \verb{struct CscMatrix} for dropping structural zeros before passing to the solver.
}
\examples{
# Default control parameters
ctrl <- clarabel_control()
ctrl$max_iter
# Custom tolerances and quiet output
ctrl <- clarabel_control(verbose = FALSE, tol_gap_rel = 1e-7, max_iter = 100L)
}
