% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_clustering.R
\name{perform_clustering}
\alias{perform_clustering}
\title{Perform clustering based on nearest neighbor distances}
\usage{
perform_clustering(data, class_column = NULL)
}
\arguments{
\item{data}{A numeric matrix or data frame of data points.}

\item{class_column}{A character string or unquoted name specifying the name of the column containing class labels.}
}
\value{
An object of class 'clap' containing:
\describe{
  \item{members}{A list of clusters with their respective data point IDs.}
  \item{cluster_df}{A data frame with cluster assignments for each data point.}
  \item{data}{The original dataset.}
}
}
\description{
Perform clustering based on nearest neighbor distances
}
\details{
This function first removes the specified class column from the data, calculates the nearest neighbor distances, and then performs clustering using a radius based on the maximum nearest neighbor distance.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  # Generate dummy data
  class1 <- matrix(rnorm(100, mean = 0, sd = 1), ncol = 2) +
    matrix(rep(c(1, 1), each = 50), ncol = 2)
  class2 <- matrix(rnorm(100, mean = 0, sd = 1), ncol = 2) +
    matrix(rep(c(-1, -1), each = 50), ncol = 2)
  datanew <- rbind(class1, class2)
  training <- data.frame(datanew, class = factor(c(rep(1, 50), rep(2, 50))))

  # Plot the dummy data to visualize overlaps
  p <- ggplot2::ggplot(training, ggplot2::aes(x = X1, y = X2, color = class)) +
    ggplot2::geom_point() +
    ggplot2::labs(title = "Dummy Data with Overlapping Classes")
  print(p)

  # Perform clustering
  cluster_result <- perform_clustering(training, class_column = class)
}

}
