% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/civis_future.R
\name{CivisFuture}
\alias{CivisFuture}
\alias{run.CivisFuture}
\alias{result.CivisFuture}
\alias{cancel.CivisFuture}
\alias{resolved.CivisFuture}
\alias{fetch_logs.CivisFuture}
\title{Evaluate an expression in Civis Platform}
\usage{
CivisFuture(
  expr = NULL,
  envir = parent.frame(),
  substitute = FALSE,
  globals = TRUE,
  packages = NULL,
  lazy = FALSE,
  local = lifecycle::deprecated(),
  gc = FALSE,
  earlySignal = FALSE,
  label = NULL,
  required_resources = list(cpu = 1024, memory = 2048, diskSpace = 4),
  docker_image_name = "civisanalytics/datascience-r",
  docker_image_tag = "latest",
  ...
)

\method{run}{CivisFuture}(future, ...)

\method{result}{CivisFuture}(future, ...)

\method{cancel}{CivisFuture}(future, ...)

\method{resolved}{CivisFuture}(future, ...)

\method{fetch_logs}{CivisFuture}(object, ...)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link[future:future]{future()}}.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the \R environment evaluating the future.}

\item{lazy}{If FALSE (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{local}{deprecated as of \code{civis} v3.0.1}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) only after the value of the future is collected.
Exactly when the values are collected may depend on various factors such
as number of free workers and whether \code{earlySignal} is TRUE (more
frequently) or FALSE (less frequently).
\emph{Some future backends may ignore this argument.}}

\item{earlySignal}{Specified whether conditions should be signaled as soon
as possible or not.}

\item{label}{A character string label attached to the future.}

\item{required_resources}{resources, see \code{\link{scripts_post_containers}}}

\item{docker_image_name}{the image for the container script.}

\item{docker_image_tag}{the tag for the Docker image.}

\item{...}{arguments to \code{\link{scripts_post_containers}}}

\item{future}{CivisFuture object.}

\item{object}{CivisFuture}
}
\value{
A \code{CivisFuture} inheriting from \code{\link[future]{Future}} that evaluates \code{expr} on the given container.
}
\description{
Evaluate an expression in Civis Platform
}
\section{Methods (by generic)}{
\itemize{
\item \code{run(CivisFuture)}: Run a CivisFuture

\item \code{result(CivisFuture)}: Return the value of a CivisFuture

\item \code{cancel(CivisFuture)}: Cancel a CivisFuture

\item \code{resolved(CivisFuture)}: Check if a CivisFuture has resolved

\item \code{fetch_logs(CivisFuture)}: Fetch logs from a CivisFuture

}}
