% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{weighted_circ_mean}
\alias{weighted_circ_mean}
\alias{weighted_circ_mean2}
\alias{weighted_circ_sd}
\alias{weighted_circ_rho}
\title{Weighted circular parameters}
\usage{
weighted_circ_mean(x, w, na.rm = FALSE)

weighted_circ_mean2(x, w, na.rm = FALSE)

weighted_circ_sd(x, w, na.rm = FALSE)

weighted_circ_rho(x, w, na.rm = FALSE)
}
\arguments{
\item{x}{vector of values (in radians)}

\item{w}{vector of weights}

\item{na.rm}{a logical value indicating whether NA values should be removed before the computation proceeds}
}
\value{
weighted mean of values in the vector
}
\description{
Weighted circular parameters
}
\section{Functions}{
\itemize{
\item \code{weighted_circ_mean()}: weighted circular mean

\item \code{weighted_circ_mean2()}: an alternative way to compute weighted circular mean (the results are the same)

\item \code{weighted_circ_sd()}: weighted circular SD

\item \code{weighted_circ_rho()}: weighted mean resultant length

}}
\examples{
x <- rnorm(1000, 0, 0.5)
w <- runif(1000, 0, 1)
weighted.mean(x, w)
weighted_circ_mean(x, w)

}
