% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{circ_loess}
\alias{circ_loess}
\title{An implementation of circular-linear locally-weighted regression (LOESS)
\loadmathjax}
\usage{
circ_loess(
  formula = NULL,
  data = NULL,
  angle = NULL,
  y = NULL,
  xseq = NULL,
  circ_space = NULL,
  span = 0.75,
  ...
)
}
\arguments{
\item{formula}{the formula, e.g., y ~ x}

\item{data}{data to use}

\item{angle}{a vector of angles (not used if a formula is provided)}

\item{y}{dependent variable vector (not used if a formula is provided)}

\item{xseq}{a grid to compute predictions on (optional, the default is to use 500 points spanning the circle)}

\item{circ_space}{circular space to use (90, 180, 360, or 2*pi)}

\item{span}{a span to adjust the degree of smoothing}

\item{...}{other arguments (ignored)}
}
\value{
an object of \code{circ_loess} class with the following parameters:
\itemize{
\item \code{angle} the angles in the data
\item \code{y} the dependent variable vales in the data
\item \code{xseq} the grid on which the loess values are estimated
\item \code{y_est} the estimated loess values
\item \code{y_se} standard errors
\item \code{w} weights
\item \code{circ_space} circular space used
\item \code{span} span used
}
}
\description{
Provides an locally-weighted average when the independent variable is circular and depended variable is linear. Mainly to use with ggplot2.
}
\details{
Weights for the regression are computed as
\mjsdeqn{w = (1-(d/d_{max})^3)^3}
where \emph{d} is the angular difference between the point at which the estimate is computed and the angles in the data, and \mjseqn{d_{max}} is the maximum possible distance. If \code{span} is above 1, all points are included and \mjseqn{d_{max} = {circ\_space}/(4*span)}. Otherwise, a proportion \mjseqn{\alpha} of the points included based on their distance to the point at which the estimate is computed and \mjseqn{d_{max}} is the corresponding maximal distance.
}
\examples{
p <- ggplot(Pascucci_et_al_2019_data, aes(x = orientation, y = err)) +
  geom_point(alpha = 0.05) +
  labs(x = "Orientation, deg.", y = "Error, deg.")
p1 <- p + geom_smooth(method = "loess") + ggtitle("Standard LOESS")
p2 <- p + geom_smooth(method = "circ_loess", method.args = list(circ_space = 180, span = 0.5)) +
  ggtitle("Circular LOESS, span = 0.5")
p3 <- p + geom_smooth(method = "circ_loess", method.args = list(circ_space = 180, span = 0.2)) +
  ggtitle("Circular LOESS, span = 0.2")
(p1 + p2 + p3)

}
\seealso{
\code{\link[stats:loess]{stats::loess()}}
}
