% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{angle_diff_rad}
\alias{angle_diff_rad}
\alias{angle_diff_360}
\alias{angle_diff_180}
\alias{angle_diff_90}
\alias{angle_diff_180_45}
\alias{angle_diff_360_90}
\title{Differences between angles in different circular spaces}
\usage{
angle_diff_rad(a, b)

angle_diff_360(a, b)

angle_diff_180(a, b)

angle_diff_90(a, b)

angle_diff_180_45(a, b)

angle_diff_360_90(a, b)
}
\arguments{
\item{a}{first angle}

\item{b}{second angle}
}
\value{
difference between a and b
}
\description{
Differences between angles in different circular spaces
}
\details{
By default, all functions return values in ± half-range space (e.g., -pi to pi for 2pi radian space used by \code{angle_diff_rad()}) but \code{angle_diff_180_45()} and \code{angle_diff_360_90()} return values in [-1/4 range, 3/4 range] space
}
\section{Functions}{
\itemize{
\item \code{angle_diff_rad()}: angle difference in radians

\item \code{angle_diff_360()}: angle difference in 360 degree space

\item \code{angle_diff_180()}: angle difference in 180 degree space (e.g., line orientation)

\item \code{angle_diff_90()}: angle difference in 90 degree space

\item \code{angle_diff_180_45()}: angle difference in 180 degree space from -45 to 135

\item \code{angle_diff_360_90()}: angle difference in 360 degree space from -90 to 270

}}
\examples{
angle_diff_180(5, 175)
angle_diff_360(5, 175)
angle_diff_90(5, 175)
angle_diff_rad(5, 175)

angle_diff_360(300, 0)
angle_diff_360_90(300, 0)
}
