% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_ci_common_risk.R
\name{ci_prop_diff_nc_strata}
\alias{ci_prop_diff_nc_strata}
\title{Stratified Newcombe Common Risk Difference Confidence Interval}
\usage{
ci_prop_diff_nc_strata(
  x,
  by,
  strata,
  conf.level = 0.95,
  correct = FALSE,
  weights_method = c("wilson", "cmh"),
  data = NULL
)
}
\arguments{
\item{x}{(\code{binary}/\code{numeric}/\code{logical})\cr
vector of a binary values, i.e. a logical vector, or numeric with values \code{c(0, 1)}}

\item{by}{(\code{string}) \cr A character or factor vector with exactly two unique levels
identifying the two groups to compare. Can also be a column name if a data
frame provided in the \code{data} argument.}

\item{strata}{(\code{numeric}) \cr A vector specifying the stratum for each observation. It needs
to be the length of x or a multiple of x if multiple levels of strata are
present. Can also be a column name (or vector of column names NOT quoted)
if a data frame provided in the \code{data} argument.}

\item{conf.level}{(\verb{scalar numeric}) \cr a scalar in (0,1) indicating the confidence level. Default is 0.95}

\item{correct}{(scalar \code{logical})\cr include the continuity correction. For further information, see for example
[ci_prop_diff_nc())].

[ci_prop_diff_nc())]: R:ci_prop_diff_nc())}

\item{weights_method}{(\code{character})\cr Can be either "wilson" or "cmh" and directs the way weights are estimated.}

\item{data}{(\code{data.frame}) \cr Optional data frame containing the variables specified in \code{x} and \code{by}.}
}
\value{
An object containing the following components:

\item{n}{Number of responses}
\item{N}{Total number}
\item{estimate}{The point estimate of the proportion}
\item{conf.low}{Lower bound of the confidence interval}
\item{conf.high}{Upper bound of the confidence interval}
\item{conf.level}{The confidence level used}
\item{weights}{Weights of each strata calculated as per the specified "weights_method" argument.}
\item{method}{Type of method used}
}
\description{
Calculates the stratified Newcombe confidence interval for unequal proportions
as described in Yan X, Su XG. Stratified Wilson and Newcombe confidence intervals
or multiple binomial proportions. Weights are estimated using CMH or Wilson methods.
}
\details{
\deqn{
L = \hat{d}_{\rm MH} - z_{\alpha/2} \sqrt{
  \sum_h w_h^2 L_{2h} (1 - L_{2h}) +
  \sum_h w_h^2 U_{1h} (1 - U_{1h})
}
}

\deqn{
U = \hat{d}_{\rm MH} + z_{\alpha/2} \sqrt{
  \sum_h w_h^2 L_{2h} (1 - L_{2h}) +
  \sum_h w_h^2 U_{1h} (1 - U_{1h})
}
}

Where:
\itemize{
\item \eqn{\hat{d}_{\rm MH}}: Mantel-Haenszel common risk difference
\item \eqn{z_{\alpha/2}}: standard normal critical value
\item \eqn{w_h}: stratum weights
\item \eqn{L_{2h}}, \eqn{U_{1h}}: Wilson-type CI limits for stratum h
}
}
\examples{
set.seed(1)
rsp <- sample(c(TRUE, FALSE), 100, TRUE)
grp <- sample(c("Placebo", "Treatment"), 100, TRUE)
strata_data <- data.frame(
  "f1" = sample(c("a", "b"), 100, TRUE),
  "f2" = sample(c("x", "y", "z"), 100, TRUE),
  stringsAsFactors = TRUE
)
strata <- interaction(strata_data)

ci_prop_diff_nc_strata(
  x = rsp, by = grp, strata = strata, weights_method = "cmh",
  conf.level = 0.95
)

}
