# WARNING - Generated by {fusen} from dev/flat_purely.Rmd: do not edit by hand

test_that("purely decorated function provides correct result", {
  expect_equal((purely(log)(10))$value, maybe::just(log(10)))
})


test_that("purely decorated function provides right result", {
  expect_equal((purely(log)(seq(1, 10)))$value, maybe::just(log(seq(1, 10))))
})

test_that("purely decorated function provides NA if problem", {
  expect_equal((purely(log)(-10))$value, maybe::nothing())
})

test_that("purely decorated function log", {
  expect_type((purely(log)(-10))$log_df, "character")
})

test_that("compose purely decorated functions", {
  pure_sqrt <- purely(sqrt)
  pure_mean <- purely(mean)
  pure_exp <- purely(exp)

  result_pipe <- 1:10 |>
    pure_sqrt() %>=%
    pure_exp() %>=%
    pure_mean()

  expect_equal(result_pipe$value, maybe::just(mean(exp(sqrt(1:10)))))
})


test_that("compose purely decorated dplyr functions on data.frame", {
  pure_select <- purely(dplyr::select)
  pure_filter <- purely(dplyr::filter)
  pure_summarise <- purely(dplyr::summarise)

  result_pure <- mtcars |>
    pure_select(am, starts_with("c")) %>=%
    pure_filter(am == 1) %>=%
    pure_summarise(mean_cyl = mean(cyl))

  result_impure <- mtcars |>
    dplyr::select(am, starts_with("c")) |>
    dplyr::filter(am == 1) |>
    dplyr::summarise(mean_cyl = mean(cyl))

  expect_equal(result_pure$value, maybe::just(result_impure))
})


test_that("compose purely decorated dplyr functions on tibbles", {
  pure_select <- purely(dplyr::select)
  pure_filter <- purely(dplyr::filter)
  pure_summarise <- purely(dplyr::summarise)

  result_pure <- mtcars |>
    tibble::as_tibble() |>
    pure_select(am, starts_with("c")) %>=%
    pure_filter(am == 1) %>=%
    pure_summarise(mean_cyl = mean(cyl))

  result_impure <- mtcars |>
    tibble::as_tibble() |>
    dplyr::select(am, starts_with("c")) |>
    dplyr::filter(am == 1) |>
    dplyr::summarise(mean_cyl = mean(cyl))

  expect_equal(result_pure$value, maybe::just(result_impure))
})


test_that("test group_by", {
  pure_group_by <- purely(dplyr::group_by)

  expect_equal(
    maybe::just(dplyr::group_by(mtcars, carb)),
    pure_group_by(mtcars, carb)$value
  )
})

# tests/testthat/test-purely.R

# (Your existing tests go here...)

# --- New tests for the 'strict' parameter ---

test_that("purely's strict parameter behaves as expected for all conditions", {
  # Helper functions to generate specific conditions
  f_error <- function(x) stop("This is a custom error")
  f_warning <- function(x) {
    warning("This is a custom warning")
    return(x) # Still returns a value
  }
  f_message <- function(x) {
    message("This is a custom message")
    return(x) # Still returns a value
  }

  # It SHOULD catch the error
  res_err_s1 <- purely(f_error, strict = 1)(10)
  expect_equal(res_err_s1$value, maybe::nothing())
  expect_equal(res_err_s1$log_df, "This is a custom error")

  # It should IGNORE the warning and return the value
  expect_warning(res_warn_s1 <- purely(f_warning, strict = 1)(10))
  expect_equal(res_warn_s1$value, maybe::just(10))
  expect_true(is.na(res_warn_s1$log_df))

  # It should IGNORE the message and return the value
  expect_message(res_msg_s1 <- purely(f_message, strict = 1)(10))
  expect_equal(res_msg_s1$value, maybe::just(10))
  expect_true(is.na(res_msg_s1$log_df))

  # It SHOULD catch the error
  res_err_s2 <- purely(f_error, strict = 2)(10)
  expect_equal(res_err_s2$value, maybe::nothing())
  expect_equal(res_err_s2$log_df, "This is a custom error")

  # Test the default behavior is the same as strict = 2
  res_err_s2_default <- purely(f_error)(10)
  expect_equal(res_err_s2_default$value, maybe::nothing())

  # It SHOULD catch the warning
  res_warn_s2 <- purely(f_warning, strict = 2)(10)
  expect_equal(res_warn_s2$value, maybe::nothing())
  expect_equal(res_warn_s2$log_df, "This is a custom warning")

  # It should IGNORE the message and return the value
  expect_message(res_msg_s2 <- purely(f_message, strict = 2)(10))
  expect_equal(res_msg_s2$value, maybe::just(10))
  expect_true(is.na(res_msg_s2$log_df))

  # It SHOULD catch the error
  res_err_s3 <- purely(f_error, strict = 3)(10)
  expect_equal(res_err_s3$value, maybe::nothing())
  expect_equal(res_err_s3$log_df, "This is a custom error")

  # It SHOULD catch the warning
  res_warn_s3 <- purely(f_warning, strict = 3)(10)
  expect_equal(res_warn_s3$value, maybe::nothing())
  expect_equal(res_warn_s3$log_df, "This is a custom warning")

  # It SHOULD catch the message
  res_msg_s3 <- purely(f_message, strict = 3)(10)
  expect_equal(res_msg_s3$value, maybe::nothing())
  # Note: rlang::cnd_message adds a newline to messages
  expect_equal(res_msg_s3$log_df, "This is a custom message\n")
})
