% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage.R
\name{chrome_versions}
\alias{chrome_versions}
\alias{chrome_versions_path_cache}
\alias{chrome_versions_path}
\alias{chrome_versions_add}
\alias{chrome_versions_remove}
\title{Chrome versions cache helpers}
\usage{
chrome_versions_path_cache(...)

chrome_versions_path(version = "latest", binary = "chrome", platform = NULL)

chrome_versions_add(version, binary, platform = NULL)

chrome_versions_remove(version, binary, platform = NULL, ask = TRUE)
}
\arguments{
\item{...}{Additional path parts.}

\item{version}{A character string specifying the version to list, add or
remove.}

\item{binary}{A character string specifying which binary to list. Defaults to
\code{"all"} to show all binaries, or can be one or more of of \code{"chrome"},
\code{"chrome-headless-shell"}, or \code{"chromedriver"}.}

\item{platform}{A character string specifying the platform(s) to list. If
\code{NULL} (default), the platform will be automatically detected, or if
\code{"all"}, then binaries for all platforms will be listed.}

\item{ask}{Whether to ask before removing files.}
}
\value{
A character vector of Chrome binary paths.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#Experimental}{\figure{lifecycle-experimental.svg}{options: alt='[E]'}}}{\strong{[E]}}

These functions help interact with the cache used by \pkg{chromote}'s for
storing versioned Chrome for Testing binaries:
\itemize{
\item \code{chrome_versions_path()}: Returns a path or paths to specific Chrome
binaries in the cache.
\item \code{chrome_versions_add()}: Add a specific version to the Chrome versions
cache.
\item \code{chrome_versions_remove()}: Remove specific versions and binaries from the
Chrome cache. The \code{version}, \code{binary} and \code{platform} arguments can each
take \code{"all"} to remove all installed copies of that version, binary or
platform.
\item \code{chrome_versions_path_cache()}: Returns the path to the cache directory
used for Chrome binaries.
}

Managed Chrome installations is an experimental feature introduced in
chromote v0.5.0 and was inspired by similar features in
\href{https://playwright.dev/}{playwright}.
}
\seealso{
\code{\link[=chrome_versions_list]{chrome_versions_list()}}
}
