# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' The Chopthin Resampler
#'
#' A fast implementation of the Chopthin resampler. Can be used as the
#' resampling step in particle filters and in sequential Monte Carlo.
#'
#' @param w a vector of weights
#' @param N target number of particles
#' @param eta upper bound on the ratio between the weights. Must be >=4.
#'        If eta=Inf then only thinnig is performed, requiring the number of weights to be at least N.
#' @param normalise Flag for controlling if the returned weights should
#'        be normalised. If TRUE (default) then the sum of the returned
#'        weights will sum to N. If FALSE then the returned weights have
#'        the same sum as the original weights (within the numerical precision).
#' @param checks Flag controlling if checks on the input and the result should be performed. Default TRUE.
#' @return A list with two elements: new weights and indices
#' of the ancestors of the new particles. The weights are normalised to add up to N.
#'
#' @references
#' A Gandy and F. D-H Lau. The chopthin algorithm for
#' resampling.  IEEE Transactions on Signal Processing, 64(16):4273--4281, 2016
#'
#' @examples
#' chopthin(runif(10),N=10)
#' chopthin(runif(10),N=20,4)
#' chopthin(runif(10),N=5)
#' chopthin(runif(10),N=1)
#' @export
chopthin <- function(w, N, eta = 5.828427, normalise = TRUE, checks = TRUE) {
    .Call(`_chopthin_chopthin`, w, N, eta, normalise, checks)
}

