% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chopper.R, R/main.R
\docType{package}
\name{chopper}
\alias{chopper}
\alias{chopper-package}
\title{chopper: Change Point Product-of-Experts Ensemble}
\usage{
chopper(
  ts,
  horizon,
  decay = 0.5,
  n_samples = 1000,
  alt_mode = FALSE,
  reverse = FALSE
)
}
\arguments{
\item{ts}{A numeric vector representing the input time series.}

\item{horizon}{An integer specifying the number of future time steps to forecast.}

\item{decay}{A numeric value controlling the exponential decay rate used to the softmax weight forecasts from each segment (default is 0.5).}

\item{n_samples}{An integer specifying the number of samples drawn for estimating the forecast distributions (default is 1000).}

\item{alt_mode}{Logical flag: when TRUE, fits models on independent segments between changepoints instead of cumulative segments up to each changepoint (default: FALSE).}

\item{reverse}{Logical flag: when TRUE, inverts the weight vector (default: FALSE).}
}
\value{
A named list of forecast distributions, one for each time step in the forecast horizon. Weights for each segment
are assigned based on the softmax of exponential decay calculated at the end position of each segment.

Each distribution is represented as a list containing:
\describe{
  \item{rfun}{A random sampling function for drawing synthetic future values.}
  \item{dfun}{A density function over the predicted values.}
  \item{pfun}{A cumulative distribution function.}
  \item{qfun}{A quantile function.}
}
}
\description{
Implements a change point-aware ensemble forecasting algorithm that combines Theta, TBATS, and ARFIMA models using a product-of-experts approach for robust probabilistic prediction

A changepoint-aware probabilistic forecasting algorithm for univariate time series.
This function decomposes the input series into structurally homogeneous segments
to detect changepoints in both mean and variance. On each segment, three distinct probabilistic forecasting models
are applied—TBATS, Theta and ARFIMA to estimate future trajectories.
}
\details{
Instead of relying on a single model, `chopper()` embraces the variety of probabilistic forecasts by merging
their output using a product-of-experts composition rule. This method allows each model to contribute to the
final distribution proportionally to the confidence it assigns to different outcomes.

The final output is a collection of forecast distributions—one for each horizon step—that captures both
epistemic uncertainty (from model disagreement) and aleatoric uncertainty (from residual variability).


This function uses the `changepoint` package to perform offline changepoint detection
on the historical series. For each segment identified, four forecasting models are fit:
\itemize{
  \item \strong{Theta}: decomposed trend extrapolation with adjusted curvature.
  \item \strong{TBATS}: based on exponential smoothing, designed for time series data with multiple seasonalities.
  \item \strong{ARFIMA}: a long-memory extension of ARIMA that captures persistence in volatility and mean.
}

The output of each model is converted to a forecast density for each horizon step. These are multiplied together
(product of experts) and normalized over a shared evaluation grid. A weighted average of these densities is
constructed across segments using segment-specific weights based on softmax and exponential decay.
}
\examples{
\donttest{
# Fast example with the tail of a time series
forecasted <- chopper(ts = tail(ts_set$AMZN.Close, 70), horizon = 5, n_samples = 100)

# Draw samples from forecast for t1 and t5
forecasted$pred_funs$t1$rfun(10)
forecasted$pred_funs$t5$rfun(10)

}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/chopper}
}

}
\author{
\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]

}
