% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.trans.counts.R
\name{get.trans.counts}
\alias{get.trans.counts}
\title{get.trans.counts}
\usage{
get.trans.counts(interaction.data)
}
\arguments{
\item{interaction.data}{Data table containing interactions}
}
\value{
Data table with columns \code{fragment.id} and \code{trans.count}.
\item{fragment.id}{ID of restriction fragment in chrN:start-end format}
\item{trans.count}{Number of trans interactions involving the fragment}
}
\description{
Calculate the number of trans-interactions per fragment, accounting for the fact that baits can be listed either as bait or target.
}
\examples{
	data(bre80);
	get.trans.counts(bre80[, .(bait.chr, target.chr, bait.id, target.id, count)]);

}
