% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fstg02.R
\docType{data}
\name{fstg02_main}
\alias{fstg02_main}
\alias{fstg02_pre}
\alias{fstg02}
\title{\code{FSTG02} Subgroup Analysis of Survival Duration.}
\format{
An object of class \code{chevron_g} of length 1.
}
\usage{
fstg02_main(
  adam_db,
  dataset = "adtte",
  arm_var = "ARM",
  subgroups = c("SEX", "AGEGR1", "RACE"),
  strata_var = NULL,
  stat_var = c("n_tot", "n", "median", "hr", "ci"),
  ...
)

fstg02_pre(adam_db, ...)

fstg02
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{arm_var}{(\code{string}) the arm variable name used for group splitting.}

\item{subgroups}{(\code{character}) the subgroups variable name to list baseline risk factors.}

\item{strata_var}{(\code{character}) required if stratified analysis is performed.}

\item{stat_var}{(\code{character}) the names of statistics to be reported in \code{tabulate_survival_subgroups}.}

\item{...}{Further arguments passed to \code{g_forest} and \code{extract_rsp_subgroups} (a wrapper for
\code{h_odds_ratio_subgroups_df} and \code{h_proportion_subgroups_df}). For details, see the documentation in \code{tern}.
Commonly used arguments include \code{gp}, \code{col_symbol_size}, \code{col}, \code{vline}, \code{groups_lists}, \code{conf_level},
\code{method}, \code{label_all}, etc.}
}
\value{
the main function returns a \code{gTree} object.

a \code{gTree} object.

the preprocessing function returns a \code{list} of \code{data.frame}.
}
\description{
The template produces the subgroup analysis of survival duration graphic.
}
\details{
\itemize{
\item No overall value.
\item Keep zero count rows by default.
}
}
\section{Functions}{
\itemize{
\item \code{fstg02_main()}: Main TLG Function

\item \code{fstg02_pre()}: Preprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain the table specified by \code{dataset} with \code{"PARAMCD"}, \code{"ARM"},
\code{"AVAL"}, \code{"AVALU"}, \code{"CNSR"}, and the columns specified by \code{subgroups} which is denoted as
\code{c("SEX", "AGEGR1", "RACE")} by default.
\item If the plot is too large to be rendered in the output, please refer to \code{FSTG01}.
}
}
\examples{
library(dplyr)
library(dunlin)

proc_data <- log_filter(
  syn_data,
  PARAMCD == "OS" & ARM \%in\% c("A: Drug X", "B: Placebo"), "adtte"
)
run(fstg02, proc_data,
  subgroups = c("SEX", "AGEGR1", "RACE"),
  conf_level = 0.90, dataset = "adtte"
)
}
\keyword{datasets}
