% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{options}
\alias{options}
\title{checked Options}
\description{
Internally used, package-specific options. All options will prioritize R options() values, and fall back to environment variables if undefined. If neither the option nor the environment variable is set, a default value is used.
}
\section{Checking Option Values}{

Option values specific to \code{checked} can be
accessed by passing the package name to \code{env}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{options::opts(env = "checked")

options::opt(x, default, env = "checked")
}\if{html}{\out{</div>}}
}

\section{Options}{

\describe{
\item{tty_tick_interval}{\describe{
tty refresh interval when reporting results in milliseconds\item{default: }{\preformatted{0.1}}
\item{option: }{checked.tty_tick_interval}
\item{envvar: }{R_CHECKED_TTY_TICK_INTERVAL (evaluated if possible, raw string otherwise)}
}}

\item{tty_default_height}{\describe{
deafult tty height used for the ANSI reporter. Used only
if correct values could not be acquired with system('tput lines')\item{default: }{\preformatted{50}}
\item{option: }{checked.tty_default_height}
\item{envvar: }{R_CHECKED_TTY_DEFAULT_HEIGHT (evaluated if possible, raw string otherwise)}
}}

\item{proactive_gc}{\describe{
\code{logical}, indicating whether additional garbage collection should be
performed before starting a new task, if at least one process recently
finalized. This can cause the checker to orchestrate tasks slower but
is recommended to be used for designs with many sub-processes required as
native garbage collection can lag leading to memory issues. Disable only
when maximum prefromance is required and memory is not the issue.\item{default: }{\preformatted{TRUE}}
\item{option: }{checked.proactive_gc}
\item{envvar: }{R_CHECKED_PROACTIVE_GC (evaluated if possible, raw string otherwise)}
}}

\item{results_error_on}{\describe{
character vector indicating whether R error should be thrown when issues
are discovered when generating results. "never" means that no errors
are thrown. If "issues" then errors are emitted only on issues, whereas
"potential issues" stands for error on both issues and potential issues.\item{default: }{\preformatted{"never"}}
\item{option: }{checked.results_error_on}
\item{envvar: }{R_CHECKED_RESULTS_ERROR_ON (evaluated if possible, raw string otherwise)}
}}

\item{results_keep}{\describe{
character vector indicating which packages should be included in the results.
"all" means that all packages are kept. If "issues" then only packages
with issues identified, whereas "potential_issues" stands for keeping
packages with both "issues" and "potential_issues".\item{default: }{\preformatted{"all"}}
\item{option: }{checked.results_keep}
\item{envvar: }{R_CHECKED_RESULTS_KEEP (evaluated if possible, raw string otherwise)}
}}

\item{restore}{\describe{
\code{logical} indicating whether output directory should be unlinked before
running checks. If \code{FALSE}, an attempt will me made to restore previous
progress from the same \code{output}\item{default: }{\preformatted{NA}}
\item{option: }{checked.restore}
\item{envvar: }{R_CHECKED_RESTORE (evaluated if possible, raw string otherwise)}
}}

\item{add_remotes}{\describe{
\code{logical} indicating whether origins inheriting from \code{pkg_origin_local},
should be scanned for packages in the \code{remotes} field and added while
constrocuting a plan \code{task_grap}\item{default: }{\preformatted{TRUE}}
\item{option: }{checked.add_remotes}
\item{envvar: }{R_CHECKED_ADD_REMOTES (evaluated if possible, raw string otherwise)}
}}

\item{check_envvars}{\describe{
named \code{character} vector of environment variables to use during
the R CMD check.\item{default: }{\preformatted{c(`_R_CHECK_FORCE_SUGGESTS_` = "false", `_R_CHECK_RD_XREFS_` = "false", 
    `_R_CHECK_SYSTEM_CLOCK_` = "false", `_R_CHECK_SUGGESTS_ONLY_` = "true", 
    `_R_CHECK_CRAN_INCOMING_` = "false")}}
\item{option: }{checked.check_envvars}
\item{envvar: }{R_CHECKED_CHECK_ENVVARS (evaluated if possible, raw string otherwise)}
}}

\item{check_build_args}{\describe{
\code{character} vector of args passed to the R CMD build.\item{default: }{\preformatted{c("--no-build-vignettes", "--no-manual")}}
\item{option: }{checked.check_build_args}
\item{envvar: }{R_CHECKED_CHECK_BUILD_ARGS (space-separated R CMD build flags)}
}}

\item{check_args}{\describe{
\code{character} vector of args passed to the R CMD check.\item{default: }{\preformatted{c("--timings", "--ignore-vignettes", "--no-manual", "--as-cran")}}
\item{option: }{checked.check_args}
\item{envvar: }{R_CHECKED_CHECK_ARGS (space-separated R CMD check flags)}
}}

}
}

\seealso{
options getOption Sys.setenv Sys.getenv

Other documentation: 
\code{\link{options_params}}
}
\concept{documentation}
