library(checkargs)
context("isZeroVector")

test_that("isZeroVector works for all arguments", {
  expect_identical(isZeroVector(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isZeroVector(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector("", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isZeroVector(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isZeroVector(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_error(isZeroVector(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isZeroVector(0, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isZeroVector(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector("", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector("X", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isZeroVector(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isZeroVector(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isZeroVector(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
})
