library(checkargs)
context("isNaOrNonEmptyStringScalar")

test_that("isNaOrNonEmptyStringScalar works for all arguments", {
  expect_identical(isNaOrNonEmptyStringScalar(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNaOrNonEmptyStringScalar(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar("", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isNaOrNonEmptyStringScalar(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isNaOrNonEmptyStringScalar(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_error(isNaOrNonEmptyStringScalar(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isNaOrNonEmptyStringScalar(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isNaOrNonEmptyStringScalar(0, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar("", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isNaOrNonEmptyStringScalar("X", stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isNaOrNonEmptyStringScalar(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isNaOrNonEmptyStringScalar(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
})
