% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isNegativeNumberOrNanOrInfScalar.R
\name{isNegativeNumberOrNanOrInfScalar}
\alias{isNegativeNumberOrNanOrInfScalar}
\title{Wrapper for the checkarg function, using specific parameter settings.}
\usage{
isNegativeNumberOrNanOrInfScalar(argument, default = NULL,
  stopIfNot = FALSE, message = NULL, argumentName = NULL)
}
\arguments{
\item{argument}{See checkarg function.}

\item{default}{See checkarg function.}

\item{stopIfNot}{See checkarg function.}

\item{message}{See checkarg function.}

\item{argumentName}{See checkarg function.}
}
\value{
See checkarg function.
}
\description{
This function can be used in 3 ways:\enumerate{
  \item Return TRUE or FALSE depending on whether the argument checks are
     passed. This is suitable e.g. for if statements that take further action
     if the argument does not pass the checks.\cr
  \item Throw an exception if the argument does not pass the checks. This is
     suitable e.g. when no further action needs to be taken other than
     throwing an exception if the argument does not pass the checks.\cr
  \item Same as (2) but by supplying a default value, a default can be assigned
     in a single statement, when the argument is NULL. The checks are still
     performed on the returned value, and an exception is thrown when not
     passed.\cr
}
}
\details{
Actual call to checkarg: checkarg(argument, "N", default = default, stopIfNot = stopIfNot, nullAllowed = FALSE, n = 1, zeroAllowed = TRUE, negativeAllowed = TRUE, positiveAllowed = FALSE, nonIntegerAllowed = TRUE, naAllowed = FALSE, nanAllowed = TRUE, infAllowed = TRUE, message = message, argumentName = argumentName)
}
\examples{
isNegativeNumberOrNanOrInfScalar(-2)
   # returns TRUE (argument is valid)
isNegativeNumberOrNanOrInfScalar("X")
   # returns FALSE (argument is invalid)
#isNegativeNumberOrNanOrInfScalar("X", stopIfNot = TRUE)
   # throws exception with message defined by message and argumentName parameters
isNegativeNumberOrNanOrInfScalar(-2, default = -1)
   # returns -2 (the argument, rather than the default, since it is not NULL)
#isNegativeNumberOrNanOrInfScalar("X", default = -1)
   # throws exception with message defined by message and argumentName parameters
isNegativeNumberOrNanOrInfScalar(NULL, default = -1)
   # returns -1 (the default, rather than the argument, since it is NULL)

}
