% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkarg.R
\name{checkarg}
\alias{checkarg}
\title{Perform a basic check on the type of an argument and its value(s) and set a
default value if applicable.}
\usage{
checkarg(argument, content, default = NULL, stopIfNot = FALSE,
  nullAllowed = FALSE, n = 1, naAllowed = FALSE, nanAllowed = TRUE,
  infAllowed = TRUE, nonIntegerAllowed = TRUE, negativeAllowed = TRUE,
  zeroAllowed = TRUE, positiveAllowed = TRUE, emptyStringAllowed = TRUE,
  message = "Argument \\\\1has invalid value", argumentName = "")
}
\arguments{
\item{argument}{Argument to check.}

\item{content}{Required content of argument, case-insensitive. Either
"BOOLEAN" (short: "B") for an argument of primitive type logical, "NUMBER"
(short: "N") for an argument of primitive type numeric, or "STRING" (short:
"S") for an argument of primitive type character.}

\item{default}{If not NULL and the argument is NULL, the default value is
returned instead of the result of the content checks (TRUE or FALSE).
Parameter stopIfNot must be set to TRUE in this case. The content of the
default value is not checked.}

\item{stopIfNot}{If TRUE and the argument checks fail, an exception is be
thrown. Must be set to TRUE if parameter default is not NULL.}

\item{nullAllowed}{If TRUE, argument may be NULL.}

\item{n}{Number of elements the argument must have. Default: n = 1, i.e. a
scalar value is expected. If NA, any length is allowed. If the argument has
zero elements and either n = 0 or n = NA, only the primitive type is
checked and no other checks on content are applied.}

\item{naAllowed}{If TRUE, NA value(s) are allowed. If FALSE, NaN value(s),
which also test true for is.na, are ignored and can be further constrained
by nanAllowed.}

\item{nanAllowed}{If TRUE, NaN value(s) are allowed.}

\item{infAllowed}{If TRUE, Inf value(s) are allowed.}

\item{nonIntegerAllowed}{If TRUE, non-integer value(s) are allowed. If
FALSE, NA, NaN and Inf value(s), which are not integers, are ignored and
can instead be constrained further by respectively naAllowed, nanAllowed
and infAllowed.}

\item{negativeAllowed}{If TRUE, negative value(s) are allowed.}

\item{zeroAllowed}{If TRUE, zero value(s) are allowed.}

\item{positiveAllowed}{If TRUE, positive value(s) are allowed.}

\item{emptyStringAllowed}{If TRUE, empty string value(s) are allowed.}

\item{message}{The message provided when an exception is thrown. The
first instance of \\1 is replaced with '\'argumentName\' ', if the latter
is not empty. If NULL, the same default message is used.}

\item{argumentName}{The name of the variable to be used in the exception
message. If NULL, the same default argumentName is used.}
}
\value{
If no default is provided, i.e. if the default parameter is not
  null): TRUE is returned if the argument passes the checks and otherwise
  FALSE. If a default is provided, the default is returned in case the
  argument is null and otherwise the argument is returned.
}
\description{
This function is the main function that all isXxx functions are wrappers
around, each with specific parameter settings. It can be used in 3 ways:\enumerate{
  \item Return TRUE or FALSE depending on whether the argument checks are
     passed. This is suitable e.g. for if statements that take further action
     if the argument does not pass the checks.\cr
  \item Throw an exception if the argument does not pass the checks. This is
     suitable e.g. when no further action needs to be taken other than
     throwing an exception if the argument does not pass the checks.\cr
  \item Same as (2) but by supplying a default value, a default can be assigned
     in a single statement, when the argument is NULL. The checks are still
     performed on the returned value, and an exception is thrown when not
     passed.\cr
 }
}
\examples{
checkarg(TRUE, "BOOLEAN")
  # returns TRUE (argument is valid)
checkarg(FALSE, "BOOLEAN")
  # returns TRUE (argument is valid)
checkarg(1, "BOOLEAN")
  # returns FALSE (argument is invalid)
checkarg("Y", "BOOLEAN")
  # returns FALSE (argument is invalid)
#checkarg("Y", "BOOLEAN", stopIfNot = TRUE)
  # throws exception with message defined by message and argumentName parameters

checkarg(1, "NUMBER", default = 0)
  # returns 1 (argument is returned if provided, i.e. not NULL, and valid)
checkarg(NULL, "NUMBER", default = 0)
  # returns 0 (default is returned since argument is not provided)
checkarg(NULL, "NUMBER", default = 0)
  # returns 0 (default is returned since argument is not provided)
checkarg(NA, "NUMBER")
  # returns FALSE (NA values are not allowed by default)
checkarg(NA, "NUMBER", naAllowed = TRUE)
  # returns TRUE (NA values are allowed)
checkarg(c(0, 1), "NUMBER")
  # returns FALSE (scalar value expected by default)
checkarg(c(0, 1), "NUMBER", n = NA)
  # returns TRUE (any length vector allowed)

checkarg("X", "STRING")
  # returns TRUE (argument is valid)
checkarg(TRUE, "STRING")
  # returns FALSE (argument is invalid)
checkarg(1, "STRING")
  # returns FALSE (argument is invalid)

}
