% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_regression.R
\name{local.refine.regression}
\alias{local.refine.regression}
\title{Local refinement for regression change points localisation.}
\usage{
local.refine.regression(cpt_init, y, X, zeta)
}
\arguments{
\item{cpt_init}{An \code{integer} vector of initial changepoints estimation (sorted in strictly increasing order).}

\item{y}{A \code{numeric} vector of response variable.}

\item{X}{A \code{numeric} matrix of covariates with vertical axis being time..}

\item{zeta}{A \code{numeric} scalar of tuning parameter for the group lasso.}
}
\value{
A vector of locally refined change points estimation.
}
\description{
Perform local refinement for regression change points localisation.
}
\examples{
d0 = 10
p = 20
n = 100
cpt_true = c(30, 70)
data = simu.change.regression(d0, cpt_true, p, n, sigma = 1, kappa = 9)
gamma_set = c(0.01, 0.1, 1)
lambda_set = c(0.01, 0.1, 1, 3)
temp = CV.search.DP.regression(y = data$y, X = data$X, gamma_set, lambda_set, delta = 2)
temp$test_error # test error result
# find the indices of gamma_set and lambda_set which minimizes the test error
min_idx = as.vector(arrayInd(which.min(temp$test_error), dim(temp$test_error)))
gamma_set[min_idx[1]]
lambda_set[min_idx[2]]
cpt_init = unlist(temp$cpt_hat[min_idx[1], min_idx[2]])
local.refine.regression(cpt_init, data$y, X = data$X, zeta = 0.5)
}
\references{
Rinaldo, A., Wang, D., Wen, Q., Willett, R., & Yu, Y. (2021, March). Localizing changes in high-dimensional regression models. In International Conference on Artificial Intelligence and Statistics (pp. 2089-2097). PMLR.

Rinaldo, Wang, Wen, Willett and Yu (2020) <arxiv:2010.10410>
}
\author{
Daren Wang & Haotian Xu
}
