% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_recruiting.R
\name{cfbd_recruiting_transfer_portal}
\alias{cfbd_recruiting_transfer_portal}
\title{\strong{Get Transfer Portal Data}}
\usage{
cfbd_recruiting_transfer_portal(year)
}
\arguments{
\item{year}{(\emph{Integer} required): Year of the offseason (2021 would return transfer portal data starting from the end of the 2020 season), 4 digit format (\emph{YYYY}).}
}
\value{
\code{\link[=cfbd_recruiting_transfer_portal]{cfbd_recruiting_transfer_portal()}} - A data frame with 11 variables:
\describe{
\item{\code{season}:integer}{Season of transfer.}
\item{\code{first_name}:character.}{Player's first name.}
\item{\code{last_name}:character.}{Player's last name.}
\item{\code{position}:character.}{Player position.}
\item{\code{origin}:character.}{original team.}
\item{\code{destination}:character.}{new team.}
\item{\code{transfer_date}:character.}{Date of transfer.}
\item{\code{rating}:character.}{Player's 247 transfer rating.}
\item{\code{stars}:integer}{Player's star rating.}
\item{\code{eligibilty}:character.}{Player's eligibilty status.}
}
}
\description{
\strong{Get Transfer Portal Data}
}
\examples{
\donttest{
  try(cfbd_recruiting_transfer_portal(year = 2021))
}
}
\seealso{
Other CFBD Recruiting: 
\code{\link{cfbd_recruiting_player}()},
\code{\link{cfbd_recruiting_position}()},
\code{\link{cfbd_recruiting_team}()}
}
\concept{CFBD Recruiting}
\keyword{Recruiting}
