% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_wp}
\alias{cfbd_metrics_wp}
\title{\strong{Get win probability chart data from API}}
\usage{
cfbd_metrics_wp(game_id)
}
\arguments{
\item{game_id}{(\emph{Integer} required): Game ID filter for querying a single game
Can be found using the \code{\link[=cfbd_game_info]{cfbd_game_info()}} function}
}
\value{
\code{\link[=cfbd_metrics_wp]{cfbd_metrics_wp()}} - A data frame with 16 variables:
\describe{
\item{\code{play_id}: character.}{Play referencing id.}
\item{\code{play_text}: character.}{A text description of the play.}
\item{\code{home_id}: integer.}{Home team referencing id.}
\item{\code{home}: character.}{Home team name.}
\item{\code{away_id}: integer.}{Away team referencing id.}
\item{\code{away}: character.}{Away team name.}
\item{\code{spread}: character.}{Betting lines provider spread.}
\item{\code{home_ball}: logical.}{Home team has the ball.}
\item{\code{home_score}: integer.}{Home team score.}
\item{\code{away_score}: integer.}{Away team score.}
\item{\code{down}: integer.}{Down of the play.}
\item{\code{distance}: integer.}{Distance to the sticks (to 1st down marker of goal-line in goal-to-go situations).}
\item{\code{home_win_prob}: character.}{Home team win probability.}
\item{\code{away_win_prob}: double.}{Away team win probability.}
\item{\code{play_number}: integer.}{Game play number.}
\item{\code{yard_line}: integer.}{Yard line of the play (0-100 yards).}
}
}
\description{
\strong{Get win probability chart data from API}
}
\examples{
\donttest{
  try(cfbd_metrics_wp(game_id = 401012356))
}
}
\seealso{
Other CFBD Metrics: 
\code{\link{cfbd_metrics_fg_ep}()},
\code{\link{cfbd_metrics_ppa_games}()},
\code{\link{cfbd_metrics_ppa_players_games}()},
\code{\link{cfbd_metrics_ppa_players_season}()},
\code{\link{cfbd_metrics_ppa_predicted}()},
\code{\link{cfbd_metrics_ppa_teams}()},
\code{\link{cfbd_metrics_wepa_players_kicking}()},
\code{\link{cfbd_metrics_wepa_players_passing}()},
\code{\link{cfbd_metrics_wepa_players_rushing}()},
\code{\link{cfbd_metrics_wepa_team_season}()},
\code{\link{cfbd_metrics_wp_pregame}()}
}
\concept{CFBD Metrics}
\keyword{Chart}
\keyword{Data}
\keyword{Probability}
\keyword{Win}
