% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_live_scoreboard}
\alias{cfbd_live_scoreboard}
\title{\strong{Get live game scoreboard information from games.}}
\usage{
cfbd_live_scoreboard(division = "fbs", conference = NULL)
}
\arguments{
\item{division}{(\emph{String} optional): Division abbreviation - Select a valid division: fbs/fcs/ii/iii}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_live_scoreboard]{cfbd_live_scoreboard()}} - A data frame with 41 variables:\tabular{ll}{
   col_name \tab types \cr
   game_id \tab integer \cr
   start_date \tab character \cr
   start_time_tbd \tab logical \cr
   tv \tab character \cr
   neutral_site \tab logical \cr
   conference_game \tab logical \cr
   status \tab character \cr
   period \tab integer \cr
   clock \tab character \cr
   situation \tab character \cr
   possession \tab character \cr
   last_play \tab character \cr
   venue_name \tab character \cr
   venue_city \tab character \cr
   venue_state \tab character \cr
   home_team_id \tab integer \cr
   home_team_name \tab character \cr
   home_team_conference \tab character \cr
   home_team_classification \tab character \cr
   home_team_points \tab integer \cr
   home_team_line_scores_Q1 \tab integer \cr
   home_team_line_scores_Q2 \tab integer \cr
   home_team_line_scores_Q3 \tab integer \cr
   home_team_line_scores_Q4 \tab integer \cr
   away_team_id \tab integer \cr
   away_team_name \tab character \cr
   away_team_conference \tab character \cr
   away_team_classification \tab character \cr
   away_team_points \tab integer \cr
   away_team_line_scores_Q1 \tab integer \cr
   away_team_line_scores_Q2 \tab integer \cr
   away_team_line_scores_Q3 \tab integer \cr
   away_team_line_scores_Q4 \tab integer \cr
   weather_temperature \tab numeric \cr
   weather_description \tab character \cr
   weather_wind_speed \tab numeric \cr
   weather_wind_direction \tab integer \cr
   betting_spread \tab numeric \cr
   betting_over_under \tab numeric \cr
   betting_home_moneyline \tab integer \cr
   betting_away_moneyline \tab integer \cr
}
}
\description{
\strong{Get live game scoreboard information from games.}
}
\examples{
\donttest{
  try(cfbd_live_scoreboard(division='fbs', conference = "B12"))
}
}
\seealso{
Other CFBD Games: 
\code{\link{cfbd_calendar}()},
\code{\link{cfbd_game_box_advanced}()},
\code{\link{cfbd_game_info}()},
\code{\link{cfbd_game_media}()},
\code{\link{cfbd_game_player_stats}()},
\code{\link{cfbd_game_records}()},
\code{\link{cfbd_game_team_stats}()},
\code{\link{cfbd_game_weather}()}
}
\concept{CFBD Games}
\keyword{Game}
\keyword{Scoreboard}
