#' Sample data set
#'
#' A dataset relating the effective number of parties to the
#' number of presidential candidates and presidential power.
#' 
#'
#' @format A data frame with rows and 9 variables:
#' \describe{
#'   \item{country}{name of the country}
#'   \item{enep}{Effective number of legislative parties}
#'   \item{enpc}{Number of presidential candidates}
#'   \item{fapres}{Presidential power}
#'   \item{proximity}{Proximity of the presidential and legislative elections}
#'   \item{eneg}{Eeffective number of ethnic groups}
#'   \item{logmag}{log of average district magnitudes}
#'   \item{enpcfapres}{Interaction between enpc and fapres}
#'   \item{logmag_eneg}{Interaction between logmag and eneg}
#'   ...
#' }
#' 
#' @source 
#' Jackson, John (2019) Corrected Standard Errors with Clustered
#' Data. Political Analysis.
#'
#' @references
#' Elgie, Robert, Bueur, C., Dolez, B. & Laurent, A. (2014).
#' “Proximity, Candidates, and Presidential Power: How Directly
#' Elected Presidents Shape the Legislative Party System.” Political
#' Research Quarterly. 67(3): 467 - 477.
#' 
"dcese"
