% Generated by roxygen2 (4.0.2): do not edit by hand
\name{clusterrank}
\alias{clusterrank}
\title{Find the ClusterRank ranks in a graph}
\usage{
clusterrank(graph, vids = V(graph), directed = TRUE, loops = TRUE)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{directed}{Logical scalar, whether to directed graph is analyzed. This argument is ignored for undirected graphs.}

\item{loops}{Logical; whether the loop edges are also counted.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
Mathematically, the ClusterRank score \eqn{s_{i}}{s_i} of node \eqn{i}{i} is defined as:
\deqn{s_{i} = f(c_{i})\sum_{j\in \tau _{i}}(k_{out}^{j}+1)}{s_i = f(c_i) sum(k_out,j+1, j in tau _i)}
where the term f(c_{i}) accounts for the effect of i's local clustering and the term '+1' results from the contribution of \eqn{j}{j} itself. \cr
Here \eqn{f(c_{i}) = 10^{-c_{i}}}{f(c_i) = 10^(-c_i)}
}
\details{
ClusterRank is a local ranking algorithm which takes into account not only the number of neighbors and the neighbors' influences, but also the clustering coefficient. \cr
ClusterRank can also be applied to undirected networks where the superiority of ClusterRank is significant compared with degree centrality and k-core decomposition. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=ClusterRank}{ClusterRank}
}
\examples{
g <- graph(c(1,2,2,3,3,4,4,2,2,5,5,3,4,1,4,3,1,6,6,3,3,6,2,6,5,6))
clusterrank(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Chen, Duan-Bing, et al. "Identifying influential nodes in large-scale directed networks: the role of clustering." PloS one 8.10 (2013): e77455.
}

