% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foursail.R
\name{sail_BDRF}
\alias{sail_BDRF}
\title{The SAIL BDRF function}
\usage{
sail_BDRF(w, lai, sumint, tsstoo, rsoil, rdd, tdd, tsd, rsd, tdo, rdo, tss,
  too, rsod)
}
\arguments{
\item{w}{goemeric reflectance parameter}

\item{lai}{leaf area index}

\item{sumint}{exp int}

\item{tsstoo}{Bi-directional gap fraction}

\item{rsoil}{background reflectance}

\item{rdd}{Bi-hemispherical reflectance over all in & outgoing directions
(white-sky albedo).}

\item{tdd}{Bi-hemispherical transmittance (diffuse transmittance in all directions)}

\item{tsd}{Directional hemispherical transmittance for solar flux}

\item{rsd}{Directional hemispherical reflectance for solar flux (diffuse solar angle)}

\item{tdo}{Directional hemispherical transmittance (diffuse in viewing direction)}

\item{rdo}{Directional hemispherical reflectance in viewing direction}

\item{tss}{Direct transmittance of solar flux}

\item{too}{Direct transmittance in viewing direction}

\item{rsod}{Multi scattering contribution}
}
\value{
spectra matrixwith 4 reflectance factors and canopy transmission 
for wavelengths 400 to 2500nm:
 \itemize{
\item [1] = bi-hemispherical reflectance (rddt). White-sky albedo: the reflectance of the canopy
under diffuse illumination. The BRDF integrated over all viewing and illumination directions.  
\item [2] = hemispherical directional reflectance (rsdt). Black-sky albedo: reflectance of a surface
under direct light without a diffuse component. It is the integral of the BRDF over all viewing
directions.
\item [3] = directional hemispherical reflectance (rdot). Diffuse reflectance in the vieweing
direction. 
\item [4] = bi-directional reflectance (rsot). The ratio of reflected radiance in the viewing direction
to the incoming radiant flux in the solar direction. 
\item [5] = Canopy transmission of diffuse light through the canopy (taud).
\item [6] = transmission of direct light through the canopy (taus).
}
}
\description{
The SAIL BDRF function
}
