% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_utils.R
\name{validate_and_simplify_path}
\alias{validate_and_simplify_path}
\title{Validate and Simplify a Path}
\usage{
validate_and_simplify_path(path_candidate, start_state, final_state, k)
}
\arguments{
\item{path_candidate}{Character vector of operations}

\item{start_state}{Integer vector, start state}

\item{final_state}{Integer vector, target state}

\item{k}{Integer, parameter for reverse operations}
}
\value{
List with components:
\item{valid}{Logical, whether the path is valid}
\item{path}{Simplified or original path, or NULL if invalid}
}
\description{
Verifies that a candidate path correctly transforms start_state into
final_state, then attempts to simplify it. Returns the simplified path
if it remains valid, otherwise the original.
}
\examples{
res <- validate_and_simplify_path(c("1", "3"), 1:5, c(5, 2, 3, 4, 1), k = 2)
res$valid
}
