% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nw_est.R
\name{nw_est}
\alias{nw_est}
\title{The Nadaraya-Watson modified estimator}
\usage{
nw_est(Y,
       treat,
       treat_formula,
       data,
       grid_val,
       bandw,
       treat_mod,
       link_function,
       ...)
}
\arguments{
\item{Y}{is the the name of the outcome variable contained in \code{data}.}

\item{treat}{is the name of the treatment variable contained in
\code{data}.}

\item{treat_formula}{an object of class "formula" (or one that can be
coerced to that class) that regresses \code{treat} on a linear combination
of \code{X}: a symbolic description of the model to be fitted.}

\item{data}{is a dataframe containing \code{Y} and \code{treat} and
\code{X}.}

\item{grid_val}{contains the treatment values to be evaluated.}

\item{bandw}{is the bandwidth.  Default is 1.}

\item{treat_mod}{a description of the error distribution to be used in the
model for treatment. Options include: \code{"Normal"} for normal model,
\code{"LogNormal"} for lognormal model, \code{"Sqrt"} for square-root transformation
to a normal treatment, \code{"Poisson"} for Poisson model,
\code{"NegBinom"} for negative binomial model, \code{"Gamma"} for gamma
model.}

\item{link_function}{is either "log", "inverse", or "identity" for the
"Gamma" \code{treat_mod}.}

\item{...}{additional arguments to be passed to the treatment regression function.}
}
\value{
\code{nw_est} returns an object of class "causaldrf",
a list that contains the following components:
\item{param}{parameter estimates for a nw fit.}
\item{t_mod}{the result of the treatment model fit.}
\item{call}{the matched call.}
}
\description{
This is a kernel based regression method that uses a kernel as a weighting
function to estimate the ADRF. The normal kernel is weighted by the inverse of the estimated
GPS.  See Flores et al. (2012) for more details.
}
\details{
This method is a version of the Nadarya-Watson estimator
Nadaraya (1964) which is a local constant regression but
weighted by the inverse of the estimated GPS.
}
\examples{
## Example from Schafer (2015).

example_data <- sim_data

nw_list <- nw_est(Y = Y,
                treat = T,
                treat_formula = T ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
                data = example_data,
                grid_val = seq(8, 16, by = 1),
                bandw = bw.SJ(example_data$T),
                treat_mod = "Normal")

sample_index <- sample(1:1000, 100)

plot(example_data$T[sample_index],
      example_data$Y[sample_index],
      xlab = "T",
      ylab = "Y",
      main = "nw estimate")

lines(seq(8, 16, by = 1),
      nw_list$param,
      lty = 2,
      lwd = 2,
      col = "blue")

legend('bottomright',
        "nw estimate",
        lty=2,
        lwd = 2,
        col = "blue",
        bty='Y',
        cex=1)

rm(example_data, nw_list, sample_index)
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.

Flores, Carlos A., et al. "Estimating the effects of length of exposure to
instruction in a training program: the case of job corps."
\emph{Review of Economics and Statistics} \bold{94.1} (2012): 153-171.

Nadaraya, Elizbar A. "On estimating regression."
\emph{Theory of Probability and Its Applications} \bold{9.1} (1964): 141--142.
}
\seealso{
\code{\link{nw_est}}, \code{\link{iw_est}}, \code{\link{hi_est}}, \code{\link{gam_est}},
\code{\link{add_spl_est}},
\code{\link{bart_est}}, etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

