% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_effect.R
\docType{class}
\name{causalEffect-class}
\alias{causalEffect-class}
\alias{causalEffect}
\title{causalEffect class}
\usage{
causalEffect(data, causalWeights, model.outputs, augment.estimate, call)
}
\arguments{
\item{data}{an object of class \link[=dataHolder-class]{dataHolder}}

\item{causalWeights}{an object of class \link[=causalWeights-class]{causalWeights}}

\item{model.outputs}{Outputs of the \link[=estimate_model]{estimate_model()} function}

\item{augment.estimate}{Is the estimate to be the augmented (doubly robust) estimator? TRUE/FALSE}

\item{call}{the call used to calculate the treatment effects}
}
\value{
an object of class \link[=causalEffect-class]{causalEffect}
}
\description{
causalEffect class

causalEffect constructor function
}
\details{
The variables in slot \code{augmentedData} are
\itemize{
\item \code{weights}: The \link[=causalWeights-class]{causalWeights} targeting the causal estimand.
\item \code{y_obs}: The vector of the observed outcomes for each observation
\item \code{y_0}: The outcome under the control condition. Missingness respects the design of the experiment. i.e., \eqn{Y(0) | Z = 1} = \code{NA}.
\item \code{y_hat_0}: The conditional mean outcome under the control condition. Estimated from a model.
\item \code{y_hat_1}: The conditional mean outcome under the treatment condition. Estimated from a model.
\item \code{x}: The columns denoting the covariates.
\item \code{z}: The treatment indicator.
}

The slot \code{fit} is a list with slots \code{control}, \code{treated}, and \code{overall_sample}. Control and treated will be filled if \code{estimate.separately} is TRUE in estimate_effect. \code{overall_sample} will be filled if \code{estimate.separately} is FALSE.
}
\section{Slots}{

\describe{
\item{\code{estimate}}{The estimated treatment effect.}

\item{\code{estimand}}{The estimand of interest}

\item{\code{weights}}{The weights as an object of class \link[=causalWeights-class]{causalWeights}}

\item{\code{augmentedData}}{The data as a \code{data.frame} with variables \code{weights}, \code{y_obs}, \code{y_0}, \code{y_1}, \code{y_hat_0}, \code{y_hat_1}, \code{x}, and \code{z}. See details for more info.}

\item{\code{fit}}{The fitted model if present. See details.}

\item{\code{call}}{The call from the \link[=estimate_effect]{estimate_effect()} function.}
}}

\keyword{internal}
