% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-conversions.R
\name{as_tetrad_knowledge}
\alias{as_tetrad_knowledge}
\title{Convert Knowledge to Tetrad Knowledge}
\usage{
as_tetrad_knowledge(kn)
}
\arguments{
\item{kn}{A \code{Knowledge} object.}
}
\value{
A Java \code{edu.cmu.tetrad.data.Knowledge} object.
}
\description{
Converts a \code{Knowledge} object to a Tetrad \code{edu.cmu.tetrad.data.Knowledge}.
This requires \code{rJava}. This is used internally, when setting knowledge with
\code{\link[=set_knowledge]{set_knowledge()}} for methods using the Tetrad engine. \code{\link[=set_knowledge]{set_knowledge()}} is used
internally, when using the \code{\link[=disco]{disco()}} function with knowledge given.
}
\examples{
# convert to Tetrad Knowledge via rJava
data(tpc_example)

kn <- knowledge(
  head(tpc_example),
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    oldage ~ starts_with("old")
  ),
  child_x1 \%-->\% youth_x3
)

jk <- try(as_tetrad_knowledge(kn)) # will run only if rJava/JVM available
try(print(jk)) # prints a Java reference if successful
}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
