% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-graphml.R
\name{read_graphml}
\alias{read_graphml}
\title{Read GraphML File to caugi Graph}
\usage{
read_graphml(path, class = NULL)
}
\arguments{
\item{path}{File path to the GraphML file.}

\item{class}{Graph class to assign. If \code{NULL} (default), attempts to
read from the GraphML metadata. If not present, defaults to "UNKNOWN".}
}
\value{
A \code{caugi} object.
}
\description{
Imports a GraphML file as a caugi graph. Supports GraphML files
exported from caugi with full edge type information.
}
\details{
This function provides basic GraphML import support. It reads:
\itemize{
\item Nodes and their IDs
\item Edges with source and target
\item Edge types (if present in \code{edge_type} attribute)
\item Graph class (if present in graph data)
}

For GraphML files not created by caugi, edge types default to "-->"
for directed graphs and "---" for undirected graphs.
}
\examples{
# Create and export a graph
cg <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  class = "DAG"
)

tmp <- tempfile(fileext = ".graphml")
write_graphml(cg, tmp)

# Read it back
cg2 <- read_graphml(tmp)

# Clean up
unlink(tmp)

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
