% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caugi_to.R
\name{as_igraph}
\alias{as_igraph}
\title{Convert a caugi to an igraph object}
\usage{
as_igraph(x, ...)
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{...}{Additional arguments passed to \code{igraph::graph_from_data_frame()}.}
}
\value{
An \code{igraph} object representing the same graph structure.
}
\description{
Convert a caugi to an igraph object
}
\examples{
cg <- caugi(
  A \%-->\% B,
  class = "DAG"
)
ig <- as_igraph(cg)

}
\seealso{
Other conversions: 
\code{\link{as_adjacency}()},
\code{\link{as_bnlearn}()},
\code{\link{as_caugi}()},
\code{\link{as_dagitty}()}
}
\concept{conversions}
