% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_trial.R
\name{simulate_trial}
\alias{simulate_trial}
\title{Simulates the cohort trial.}
\usage{
simulate_trial(
  n_fin,
  cohorts_start = 1,
  composite = "or",
  rr_comb1,
  rr_plac1,
  rr_comb2,
  rr_plac2,
  random_type = NULL,
  random = FALSE,
  correlation,
  prob_comb1_rr = NULL,
  prob_plac1_rr = NULL,
  prob_comb2_rr = NULL,
  prob_plac2_rr = NULL,
  stage_data = FALSE,
  cohort_random = NULL,
  cohorts_max = 4,
  sr_drugs_pos = 1,
  sr_pats = cohorts_max * (n_fin + 3 * cohorts_max),
  sr_first_pos = FALSE,
  cohort_offset = 0,
  sharing_type = "all",
  safety_prob = 0,
  cohorts_sim = Inf,
  missing_prob = 0,
  cohort_fixed = NULL,
  accrual_type = "fixed",
  accrual_param = 9,
  hist_lag = 48,
  analysis_times = c(0.5, 0.75, 1),
  time_trend = time_trend,
  ...
)
}
\arguments{
\item{n_fin}{Sample size per cohort at final}

\item{cohorts_start}{Number of cohorts to start the platform with}

\item{composite}{Rule for deriving the composite endpoint. By default "or", otherwise "and"}

\item{rr_comb1}{Response rates of treatment, histology endpoint 1}

\item{rr_plac1}{Response rate of the SoC, histology endpoint 1}

\item{rr_comb2}{Response rates of treatment, histology endpoint 2}

\item{rr_plac2}{Response rate of the SoC, histology endpoint 2}

\item{random_type}{How should the response rates be drawn randomly? Options are:

                            "absolute": Specify absolute response rates that will be drawn with a certain probability

                            "risk_difference": Specify absolute response rates for placebo which will be drawn randomly,
                            plus specify vectors for absolute treatment effects of mono therapies over placebo and
                            for combo over the mono therapies.

                            "risk_ratio": Specify absolute response rates for placebo which will be drawn randomly, plus specify vectors
                            for relative treatment effects of mono therapies over placebo and for combo over the mono therapies.

                            "odds_ratios": Specify response rate for placebo, specify odds-ratios for mono therapies
                            (via rr_back and rr_mono) and respective probabilities.
                            On top, specify interaction for the combination therapy via rr_comb with prob_rr_comb.

                            Set: odds_combo = odds_plac * or_mono1 * or_mono2 * rr_comb.
                            If rr_comb > 1 -> synergistic, if rr_comb = 1 -> additive. If rr_comb < 1 -> antagonistic.
                            Default is "NULL".}

\item{random}{Should the response rates of the arms be randomly drawn from rr_exp? Default is FALSE.}

\item{correlation}{Correlation between histology endpoints}

\item{prob_comb1_rr}{If random == TRUE, what are the probabilities with which the elements of rr_comb1 should be drawn?}

\item{prob_plac1_rr}{If random == TRUE, what are the probabilities with which the elements of rr_plac1 should be drawn?}

\item{prob_comb2_rr}{If random == TRUE, what are the probabilities with which the elements of rr_comb2 should be drawn?}

\item{prob_plac2_rr}{If random == TRUE, what are the probabilities with which the elements of rr_plac2 should be drawn?}

\item{stage_data}{Should individual stage data be passed along? Default is TRUE}

\item{cohort_random}{If not NULL, indicates that new arms/cohorts should be randomly started.
For every timestep, there is a cohort_random probability that a new cohort will be started.}

\item{cohorts_max}{Maximum number of cohorts that are allowed to be added throughout the trial}

\item{sr_drugs_pos}{Stopping rule for successful experimental arms; Default = 1}

\item{sr_pats}{Stopping rule for total number of patients; Default = cohorts_max * n_fin + error term based on randomization}

\item{sr_first_pos}{Stopping rule for first successful cohort;
if TRUE, after first cohort was found to be successful, no further cohorts will be included
but cohorts will finish evaluating, unless other stopping rules reached prior.
Default is FALSE.}

\item{cohort_offset}{Minimum number of time between adding new cohorts}

\item{sharing_type}{Which backbone and placebo data should be used for arm comparisons; Default is "all".
Another option is "concurrent" or "dynamic" or "cohort".}

\item{safety_prob}{Probability for a random stopping after every patient}

\item{cohorts_sim}{Maximum number of cohorts that can run simultaneously}

\item{missing_prob}{Probability for a missing value at final (independent of treatment)}

\item{cohort_fixed}{If not NULL, fixed timesteps after which a cohort will be included}

\item{accrual_type}{Type of patient accrual; choices are "fixed", "poisson" or "exponential"}

\item{accrual_param}{Parameter used for patient accrual}

\item{hist_lag}{Time until histology outcome is observed}

\item{analysis_times}{Vector of information fractions needed for first interim, second interim and final}

\item{time_trend}{Additive term by which response rates increase at every time step}

\item{...}{Further arguments to be passed to decision function, such as decision making criteria}
}
\value{
List containing: Responses and patients on experimental and control arm, total treatment successes and failures and final p-value
}
\description{
Simulates the cohort trial.
}
\examples{

random <- TRUE

rr_comb1 <- 0.10
prob_comb1_rr <- 1
rr_comb2 <- 0.45
prob_comb2_rr <- 1
rr_plac1 <- 0.10
prob_plac1_rr <- 1
rr_plac2 <- 0.20
prob_plac2_rr <- 1

correlation <- 0.8

cohorts_start <- 2
cohorts_max <- 5
safety_prob <- 0
sharing_type <- "concurrent"
sr_drugs_pos <- 5
sr_first_pos <- FALSE
n_fin <- 100
stage_data <- TRUE
cohort_random <- 0.01
cohort_offset <- 0
cohorts_sim <- Inf
random_type <- "absolute"
missing_prob <- 0.2
cohort_fixed <- 5
hist_lag <- 48
analysis_times <- c(0.5, 0.75, 1)
accrual_type <- "fixed"
accrual_param <- 9
time_trend <- 0.001
composite <- "or"

# Comparison IA1
Bayes_Sup11 <- matrix(nrow = 2, ncol = 2)
Bayes_Sup11[1,] <- c(0.00, 0.95)
Bayes_Sup11[2,] <- c(0.10, 0.80)
# Comparison IA2
Bayes_Sup12 <- matrix(nrow = 2, ncol = 2)
Bayes_Sup12[1,] <- c(0.00, 0.95)
Bayes_Sup12[2,] <- c(0.10, 0.80)
# Comparison IA3
Bayes_Sup13 <- matrix(nrow = 2, ncol = 2)
Bayes_Sup13[1,] <- c(0.00, 0.95)
Bayes_Sup13[2,] <- c(0.10, 0.80)

Bayes_Sup1 <- Bayes_Sup2 <- list(list(Bayes_Sup11), list(Bayes_Sup12), list(Bayes_Sup13))

# Comparison IA1
Bayes_Fut11 <- matrix(nrow = 1, ncol = 2)
Bayes_Fut11[1,] <- c(0.00, 0.20)
# Comparison IA2
Bayes_Fut12 <- matrix(nrow = 1, ncol = 2)
Bayes_Fut12[1,] <- c(0.00, 0.30)
# Comparison IA3
Bayes_Fut13 <- matrix(nrow = 1, ncol = 2)
Bayes_Fut13[1,] <- c(NA, NA)
# Endpoint 1+2
Bayes_Fut1 <- Bayes_Fut2 <- list(list(Bayes_Fut11), list(Bayes_Fut12), list(Bayes_Fut13))

simulate_trial(
 n_fin = n_fin, random_type = random_type, composite = composite,
 rr_comb1 = rr_comb1, rr_comb2 = rr_comb2, rr_plac1 = rr_plac1, rr_plac2 = rr_plac2,
 random = random, prob_comb1_rr = prob_comb1_rr, prob_comb2_rr = prob_comb2_rr,
 prob_plac1_rr = prob_plac1_rr, prob_plac2_rr = prob_plac2_rr, correlation = correlation,
 stage_data = stage_data, cohort_random = cohort_random, cohorts_max = cohorts_max,
 sr_drugs_pos = sr_drugs_pos, sharing_type = sharing_type, Bayes_Fut1 = Bayes_Fut1,
 safety_prob = safety_prob, Bayes_Sup1 = Bayes_Sup1, Bayes_Sup2 = Bayes_Sup2,
 cohort_offset = cohort_offset, sr_first_pos = sr_first_pos, Bayes_Fut2 = Bayes_Fut2,
 missing_prob = missing_prob, cohort_fixed = cohort_fixed, accrual_type = accrual_type,
 accrual_param = accrual_param, hist_lag = hist_lag, analysis_times = analysis_times,
 time_trend = time_trend, cohorts_start = cohorts_start, cohorts_sim = cohorts_sim
)

}
