% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_decision_trial.R
\name{make_decision_trial}
\alias{make_decision_trial}
\title{Checks whether decision criteria are met and updates trial results accordingly.}
\usage{
make_decision_trial(
  res_list,
  which_cohort,
  Bayes_Sup1 = NULL,
  Bayes_Fut1 = NULL,
  Bayes_Sup2 = NULL,
  Bayes_Fut2 = NULL,
  w = 0.5,
  analysis_number,
  beta_prior = 0.5,
  hist_lag,
  endpoint_number,
  analysis_time,
  dataset,
  hist_miss = TRUE,
  sharing_type,
  ...
)
}
\arguments{
\item{res_list}{List item containing individual cohort trial results so far in a format used by the
other functions in this package}

\item{which_cohort}{Current cohort that should be evaluated}

\item{Bayes_Sup1}{List of matrices with rows corresponding to number of multiple Bayesian posterior two-arm combination criteria for superiority of histology endpoint 1}

\item{Bayes_Fut1}{List of matrices with rows corresponding to number of multiple Bayesian posterior two-arm combination criteria for futility of histology endpoint 1}

\item{Bayes_Sup2}{List of matrices with rows corresponding to number of multiple Bayesian posterior two-arm combination criteria for superiority of histology endpoint 2}

\item{Bayes_Fut2}{List of matrices with rows corresponding to number of multiple Bayesian posterior two-arm combination criteria for futility of histology endpoint 2}

\item{w}{If dynamic borrowing, what is the prior choice for w. Default is 0.5.}

\item{analysis_number}{1st, second or third analysis?}

\item{beta_prior}{Prior parameter for all Beta Distributions. Default is 0.5.}

\item{hist_lag}{Histology Lag}

\item{endpoint_number}{Should histology endpoint 1 or 2 be evaluated?}

\item{analysis_time}{Platform Time of Analysis}

\item{dataset}{Dataset to be used for analysis}

\item{hist_miss}{Whether or not to exclude missing histology data}

\item{sharing_type}{Type of Data Sharing to perform}

\item{...}{Further arguments inherited from simulate_trial}
}
\value{
List containing original res_list and results of decision rules
}
\description{
Given a res_list object, checks the supplied decision criteria and saves the results in the res_list file.
}
\examples{

# Example 1

# Initialize empty data frame
cols <- c("PatID", "ArrivalTime", "Cohort", "Arm", "RespHist1", "RespHist2", "HistMissing")
df <- matrix(nrow = 100, ncol = length(cols))
colnames(df) <- cols
df <- as.data.frame(df)
df$PatID <- 1:100
df$ArrivalTime <- sort(runif(100, min = 0, max = 5))
df$Cohort <- sample(1:2, 100, replace = TRUE)
df$Arm <- sample(c("Combo", "Plac"), 100, replace = TRUE)
df$RespHist1 <- sample(0:1, 100, replace = TRUE)
df$RespHist2 <- sample(0:1, 100, replace = TRUE)
df$HistMissing <- sample(0:1, 100, replace = TRUE, prob = c(0.95, 0.05))

# Initialize res_list Object

res_list <-
rep(
  list(
    list(
      Meta = list(
        decision = rep("none", 3),
        decision_hist1 = rep("none", 3),
        decision_hist2 = rep("none", 3),
        start_n = 0,
        start_time = 0,
        pat_enrolled = 0
      ),
      Arms = rep(
        list(
          list(
            rr = NULL,
            hist_observed = 0
          )
        ),
        2
      )
    )
  ),
  2
)

arm_names <- c("Comb", "Plac")

for (i in 1:2) {
  names(res_list)[i] <- paste0("Cohort", i)
  names(res_list[[i]]$Arms) <- arm_names

  res_list[[i]]$Arms$Comb$rr <- matrix(c(0.2, 0.2), ncol = 2)
  res_list[[i]]$Arms$Plac$rr <- matrix(c(0.1, 0.1), ncol = 2)
}

sharing_type <- "all"
analysis_number <- 3
which_cohort <- 1
endpoint_number <- 2
hist_lag <- 1
analysis_time <- 6

# Comparison IA1
Bayes_Sup11 <- matrix(nrow = 2, ncol = 2)
Bayes_Sup11[1,] <- c(0.00, 0.95)
Bayes_Sup11[2,] <- c(0.10, 0.80)
# Comparison IA2
Bayes_Sup12 <- matrix(nrow = 2, ncol = 2)
Bayes_Sup12[1,] <- c(0.00, 0.95)
Bayes_Sup12[2,] <- c(NA, NA)
# Comparison IA3
Bayes_Sup13 <- matrix(nrow = 2, ncol = 2)
Bayes_Sup13[1,] <- c(0.00, 0.95)
Bayes_Sup13[2,] <- c(0.10, 0.80)

Bayes_Sup1 <- Bayes_Sup2 <- list(list(Bayes_Sup11), list(Bayes_Sup12), list(Bayes_Sup13))


# DO NOT RUN
res_list2 <-
make_decision_trial(
res_list = res_list, which_cohort = which_cohort,
analysis_number = analysis_number, endpoint_number = endpoint_number,
Bayes_Sup1 = Bayes_Sup1, Bayes_Sup2 = Bayes_Sup2,
dataset = df, analysis_time = analysis_time, hist_lag = hist_lag,
sharing_type = sharing_type
)

}
