% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_hmc_mcmc_result}
\alias{get_hmc_mcmc_result}
\title{Run Hamiltonian Monte Carlo to Get MCMC Sample Result}
\usage{
get_hmc_mcmc_result(
  neg_log_den_func,
  neg_log_den_grad_func,
  coefs_0,
  iter = 5,
  hmc_scale = 0.01,
  hmc_steps = 5
)
}
\arguments{
\item{neg_log_den_func}{A function that computes the negative log-density of the target distribution at a given position.}

\item{neg_log_den_grad_func}{A function that computes the gradient of \code{neg_log_den_func} at a given position.}

\item{coefs_0}{A numeric vector specifying the initial position of the chain in the parameter space.}

\item{iter}{An integer specifying the number of HMC sampling iterations. Defaults to 5.}

\item{hmc_scale}{A numeric value representing the scale factor for the leapfrog step size in the HMC update. Defaults to 0.01.}

\item{hmc_steps}{An integer specifying the number of leapfrog steps in each HMC update. Defaults to 5.}
}
\value{
A numeric vector representing the final position in the parameter space after the specified number of iterations.
}
\description{
This function uses Hamiltonian Monte Carlo (HMC) to generate samples for Markov Chain Monte Carlo (MCMC)
sampling from a target distribution specified by \code{neg_log_den_func}. Each iteration performs a full HMC update
to generate a new sample position.
}
