% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_glm_bayes_joint_gibbs.R
\name{cat_glm_bayes_joint_gibbs}
\alias{cat_glm_bayes_joint_gibbs}
\title{Bayesian Estimation with Gibbs Sampling for Catalytic Generalized Linear Models (GLMs) Binomial Family for Coefficients and tau}
\usage{
cat_glm_bayes_joint_gibbs(
  formula,
  cat_init,
  iter = 1000,
  warmup = 500,
  coefs_iter = 5,
  tau_0 = NULL,
  tau_alpha = 2,
  tau_gamma = 1,
  refresh = TRUE
)
}
\arguments{
\item{formula}{A formula specifying the GLMs. Should at least include response variables (e.g. \code{~.}).}

\item{cat_init}{A list generated from \code{cat_glm_initialization}.}

\item{iter}{Integer; the number of Gibbs sampling iterations (default = 1000).}

\item{warmup}{Integer; the number of initial iterations for warm-up (default = 500).}

\item{coefs_iter}{Integer; the number of iterations for the HMC step to update coefficients.}

\item{tau_0}{Initial value for tau; defaults to the number of predictors / 4 if NULL.}

\item{tau_alpha}{Shape parameter for the gamma distribution when updating tau. Default is 2.}

\item{tau_gamma}{Scale parameter for the gamma distribution when updating tau. Default is 1.}

\item{refresh}{Logical; if TRUE, displays sampling progress. Default is TRUE.}
}
\value{
A list containing the values of all the arguments and the following components:
\item{gibbs_iteration_log}{Matrix containing the coefficients and tau values from each Gibbs iteration.}
\item{inform_df}{Summary statistics of each parameter, including mean, standard error, quantiles, and effective sample size.}
\item{tau}{Mean of sampled tau values.}
\item{coefficients}{Mean of sampled coefficient values.}
}
\description{
This function uses Gibbs sampling to estimate a Bayesian GLMs Binomial Family, where both the coefficients
and tau parameter are jointly sampled. tau is updated via a gamma distribution, while coefficients are
updated using Hamiltonian Monte Carlo (HMC) sampling. The model allows for progress updates,
warm-up iterations, and initial coefficient estimation based on initial tau value.
}
\examples{
\donttest{
binomial_data <- data.frame(
  X1 = stats::rnorm(10),
  X2 = stats::rnorm(10),
  Y = stats::rbinom(10, 1, 0.5)
)

cat_init <- cat_glm_initialization(
  formula = Y ~ 1, # formula for simple model
  data = binomial_data,
  family = binomial,
  syn_size = 100, # Synthetic data size
  custom_variance = NULL, # User customized variance value
  gaussian_known_variance = FALSE, # Indicating whether the data variance is unknown
  x_degree = c(1, 1), # Degrees for polynomial expansion of predictors
  resample_only = FALSE, # Whether to perform resampling only
  na_replace = stats::na.omit # How to handle NA values in data
)

cat_model <- cat_glm_bayes_joint_gibbs(
  formula = ~.,
  cat_init = cat_init, # Only accept object generated from `cat_glm_initialization`
  iter = 10, # Number of Gibbs sampling iterations
  warmup = 5, # Number of warm-up (or burn-in) iterations for initial iterations
  coefs_iter = 2, # Number of iterations for the HMC step to update coefficients
  tau_alpha = 1, # Shape parameter for the gamma distribution when updating tau
  tau_gamma = 2, # Scale parameter for the gamma distribution when updating tau
  refresh = TRUE # Indicator for displaying sampling progress
)
cat_model
}
}
