% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_glm.R
\name{cat_glm}
\alias{cat_glm}
\title{Catalytic Generalized Linear Models (GLMs) Fitting Function with Fixed Tau}
\usage{
cat_glm(formula, cat_init, tau = NULL)
}
\arguments{
\item{formula}{A formula specifying the GLMs. Should at least include response variables (e.g. \code{~ .}).}

\item{cat_init}{A list generated from \code{cat_glm_initialization}.}

\item{tau}{Optional numeric scalar controlling the weight of the synthetic data in the coefficient estimation.
Defaults to the number of predictors / 4 for Gaussian models or the number of predictors otherwise.}
}
\value{
A list containing the values of all the arguments and the following components:
\item{coefficients}{Estimated coefficient vector.}
\item{model}{Fitted GLMs object (\code{stats::glm}).}
}
\description{
Fits a Catalytic Generalized Linear Models (GLMs) by using observed and synthetic data.
}
\examples{
gaussian_data <- data.frame(
  X1 = stats::rnorm(10),
  X2 = stats::rnorm(10),
  Y = stats::rnorm(10)
)

cat_init <- cat_glm_initialization(
  formula = Y ~ 1, # formula for simple model
  data = gaussian_data,
  syn_size = 100, # Synthetic data size
  custom_variance = NULL, # User customized variance value
  gaussian_known_variance = TRUE, # Indicating whether the data variance is known
  x_degree = c(1, 1), # Degrees for polynomial expansion of predictors
  resample_only = FALSE, # Whether to perform resampling only
  na_replace = stats::na.omit # How to handle NA values in data
)

cat_model <- cat_glm(
  formula = ~.,
  cat_init = cat_init, # Only accept object generated from `cat_glm_initialization`
  tau = 1 # Weight for synthetic data
)
cat_model
}
