% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitMatching.R
\name{FitMatching}
\alias{FitMatching}
\title{Fit Latent Trait (Matching Model)}
\usage{
FitMatching(
  list,
  N_runs = 10,
  maxit = 10000,
  method = "Nelder-Mead",
  ExtraSettings = NULL
)
}
\arguments{
\item{list}{Network List}

\item{N_runs}{Number of start points for k2 and lambda to try. The best (maximum likelihood) half will
be used to construct the probability matrix}

\item{maxit}{Default = 10'000}

\item{method}{Passed to optim, default = 'Nelder-Mead'}

\item{ExtraSettings}{Other control settings to pass to optim()}
}
\value{
Network list with added 'M_par',the best fitting parameters, 'M_ProbsMatrix', the probability matrix
}
\description{
Repeatedly fits a latent trait model to a binary interaction network to return a probability matrix
}
\details{
The optimiser is started at values derived from the row-sums and column-sums of a CCA analysis,
which correspond closely to latent traits by matching closely related species together.

The k2 and lambda parameters are started from points drawn from a uniform distribution 0:1.
}
