% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{est_glm}
\alias{est_glm}
\alias{est_gee}
\alias{est_geebin}
\alias{est_glmbin}
\title{Construct estimator for the treatment effect in RCT}
\usage{
est_glm(
  response = "y",
  treatment = "a",
  covariates = NULL,
  offset = NULL,
  id = NULL,
  level = 0.95,
  family = gaussian(),
  target.parameter = treatment,
  ...
)
}
\arguments{
\item{response}{(character) Response variable}

\item{treatment}{(character) Treatment variable. Additional care must be
taken when the treatment variable is encoded as a factor (see examples).}

\item{covariates}{(character; optional) Single or vector of covariates}

\item{offset}{(character; optional) Model offset}

\item{id}{(character; optional) Subject id variable}

\item{level}{(numeric) Confidence interval level}

\item{family}{(family or character) Exponential family that is supported by
\link[stats:glm]{stats::glm} and \link[MASS:glm.nb]{MASS::glm.nb}}

\item{target.parameter}{(character) Target parameter from model output}

\item{...}{Additional arguments to \link[lava:estimate.default]{lava::estimate}}
}
\value{
function
}
\description{
Regression-based covariate adjustment as described by Rosenblum
& van der Laan (2010). Standard errors are estimated with the Hubert-White
sandwich estimator, instead using the efficient influence function as
described in the paper. Available parametric models are (\link[stats:glm]{stats::glm} and
\link[MASS:glm.nb]{MASS::glm.nb}).
}
\examples{
\donttest{
trial <- Trial$new(
    covariates = function(n) data.frame(a = rbinom(n, 1, 0.5), x = rnorm(n)),
    outcome = setargs(outcome_count,
      mean = ~ 1 + a*x,
      par = c(1, -0.1, 0.5, 0.2),
      overdispersion = 2)
)
dd <- trial$simulate(3e2)

# crude mean comparison between arms (default behavior; y ~ a)
est <- est_glm(family = poisson)
est(dd)

# linear adjustment with one covariate (y ~ a + x)
est <- est_glm(family = poisson, covariates = "x")
est(dd)

# return estimates of all linear coefficients (useful for debugging)
est <- est_glm(family = poisson, covariates = "x", target.parameter = NULL)
est(dd)

# comparing robust and non-robust standard errors of poisson estimator by
# passing robust argument via ... to lava::estimate
estimators <- list(
  robust = est_glm(family = poisson),
  non.robust = est_glm(family = poisson, robust = FALSE)
)
res <- do.call(rbind, lapply(estimators, \(est) est(dd)$coefmat))
rownames(res) <- names(estimators)
res

dd_factor <- dd
dd_factor$a <- as.factor(dd_factor$a)
# target parameter needs to be changed because the name of the estimated
# regression coefficient changes when encoding the treatment variable as a
# factor
est_glm(family = poisson, target.parameter = "a1")(dd_factor)
}
}
\references{
Rosenblum & van der Laan (2010) Simple, Efficient Estimators of
Treatment Effects in Randomized Trials Using Generalized Linear Models to
Leverage Baseline Variables, The International Journal of Biostatistics
}
\seealso{
\link{Trial}
}
\author{
Klaus Kähler Holst
}
