% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretList.R
\name{c.caretList}
\alias{c.caretList}
\title{S3 definition for concatenating caretList}
\usage{
\method{c}{caretList}(...)
}
\arguments{
\item{...}{the objects of class caretList or train to bind into a caretList}
}
\value{
a \code{\link{caretList}} object
}
\description{
take N objects of class caretList and concatenate them into a larger object of
class caretList for future ensembling
}
\examples{
data(iris)
model_list1 <- caretList(Sepal.Width ~ .,
  data = iris,
  tuneList = list(
    lm = caretModelSpec(method = "lm")
  )
)

model_list2 <- caretList(Sepal.Width ~ .,
  data = iris, tuneLength = 1L,
  tuneList = list(
    rf = caretModelSpec(method = "rf")
  )
)

bigList <- c(model_list1, model_list2)
}
